/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class CacheContainerRemove
extends AbstractRemoveStepHandler {
    public static final CacheContainerRemove INSTANCE = new CacheContainerRemove();
    private List<Property> remainingCaches = null;

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String containerName = address.getLastElement().getValue();
        for (Property cache : this.remainingCaches) {
            String cacheName = cache.getName();
            ModelNode cacheModel = cache.getValue();
            String jndiName = (cacheModel.hasDefined("jndi-name") ? InfinispanJndiName.toJndiName(cacheModel.get("jndi-name").asString()) : InfinispanJndiName.defaultCacheJndiName(containerName, cacheName)).getAbsoluteName();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            context.removeService(bindInfo.getBinderServiceName());
            context.removeService(CacheConfigurationService.getServiceName(containerName, cacheName));
            context.removeService(CacheService.getServiceName(containerName, cacheName));
        }
        String jndiName = (model.hasDefined("jndi-name") ? InfinispanJndiName.toJndiName(model.get("jndi-name").asString()) : InfinispanJndiName.defaultCacheContainerJndiName(containerName)).getAbsoluteName();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        context.removeService(bindInfo.getBinderServiceName());
        context.removeService(EmbeddedCacheManagerService.getServiceName(containerName));
        context.removeService(EmbeddedCacheManagerConfigurationService.getServiceName(containerName));
        ServiceName channelServiceName = ChannelService.getServiceName((String)containerName);
        ServiceController channelServiceController = context.getServiceRegistry(false).getService(channelServiceName);
        if (channelServiceController != null) {
            context.removeService(channelServiceName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String[] cacheTypes;
        this.remainingCaches = new ArrayList<Property>();
        for (String cacheType : cacheTypes = new String[]{"local-cache", "invalidation-cache", "replicated-cache", "distributed-cache"}) {
            ModelNode caches = model.get(cacheType);
            if (!caches.isDefined() || caches.getType() != ModelType.OBJECT) continue;
            List cacheList = caches.asPropertyList();
            for (Property cache : cacheList) {
                String cacheName = cache.getName();
                ModelNode cacheValue = cache.getValue().clone();
                this.remainingCaches.add(new Property(cacheName, cacheValue));
            }
        }
        super.performRemove(context, operation, model);
    }
}

