/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.impl.FederatingPortletInvokerService;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.migration.InMemoryMigrationService;
import org.gatein.wsrp.consumer.registry.AbstractConsumerRegistry;

public class InMemoryConsumerRegistry
extends AbstractConsumerRegistry {
    private SortedMap<String, WSRPConsumer> consumers;
    private Map<String, String> keysToIds;

    public InMemoryConsumerRegistry() {
        this.initConsumers(null);
        this.setFederatingPortletInvoker((FederatingPortletInvoker)new FederatingPortletInvokerService());
        this.setMigrationService(new InMemoryMigrationService());
    }

    @Override
    protected void initConsumerCache() {
        this.setConsumerCache(new AbstractConsumerRegistry.InMemoryConsumerCache(this));
    }

    @Override
    public WSRPConsumer createConsumerFrom(ProducerInfo producerInfo, boolean putInCache) {
        WSRPConsumer consumer = super.createConsumerFrom(producerInfo, putInCache);
        String id = consumer.getProducerId();
        this.consumers.put(id, consumer);
        ProducerInfo info = consumer.getProducerInfo();
        this.keysToIds.put(info.getKey(), id);
        return consumer;
    }

    @Override
    public String updateProducerInfo(ProducerInfo producerInfo) {
        String oldId = super.updateProducerInfo(producerInfo);
        if (oldId != null) {
            this.keysToIds.put(producerInfo.getKey(), producerInfo.getId());
            this.consumers.remove(oldId);
        }
        return oldId;
    }

    @Override
    public void save(ProducerInfo info, String messageOnError) {
        info.setKey(UUID.randomUUID().toString());
        this.keysToIds.put(info.getKey(), info.getId());
    }

    @Override
    public void delete(ProducerInfo info) {
        String key = info.getKey();
        String removed = this.keysToIds.remove(key);
        if (removed != null) {
            this.consumers.remove(removed);
        }
    }

    @Override
    public String update(ProducerInfo producerInfo) {
        String newId;
        String key = producerInfo.getKey();
        String oldId = this.keysToIds.get(key);
        if (oldId.equals(newId = producerInfo.getId())) {
            return null;
        }
        this.keysToIds.put(key, newId);
        WSRPConsumer consumer = (WSRPConsumer)this.consumers.get(oldId);
        this.consumers.put(newId, consumer);
        return oldId;
    }

    @Override
    public void reloadConsumers() {
    }

    @Override
    public Iterator<ProducerInfo> getProducerInfosFromStorage() {
        return new AbstractConsumerRegistry.ProducerInfoIterator(this.consumers.values().iterator());
    }

    @Override
    public ProducerInfo loadProducerInfo(String id) {
        if (this.keysToIds.containsValue(id)) {
            WSRPConsumer consumer = (WSRPConsumer)this.consumers.get(id);
            return consumer != null ? consumer.getProducerInfo() : null;
        }
        return null;
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.consumers.clear();
        this.keysToIds.clear();
        this.consumers = null;
        this.keysToIds = null;
    }

    @Override
    public Collection<String> getConfiguredConsumersIds() {
        return this.consumers.keySet();
    }

    protected void initConsumers(SortedMap<String, WSRPConsumer> consumers) {
        if (!ParameterValidation.existsAndIsNotEmpty(consumers)) {
            consumers = new TreeMap<String, WSRPConsumer>();
        }
        this.consumers = consumers;
        int size = consumers.size();
        this.keysToIds = size == 0 ? new HashMap<String, String>() : new HashMap(size);
        for (WSRPConsumer consumer : consumers.values()) {
            this.keysToIds.put(consumer.getProducerInfo().getKey(), consumer.getProducerId());
        }
    }
}

