/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.services;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.services.PortCustomizer;

public class PortCustomizerRegistry {
    private static PortCustomizerRegistry instance = new PortCustomizerRegistry();
    private Set<PortCustomizer> customizers;

    private PortCustomizerRegistry() {
    }

    public static PortCustomizerRegistry getInstance() {
        return instance;
    }

    public Iterable<PortCustomizer> getPortCustomizers() {
        return this.customizers != null ? Collections.unmodifiableSet(this.customizers) : Collections.emptySet();
    }

    public boolean hasWSSFocusedCustomizers() {
        for (PortCustomizer customizer : this.customizers) {
            if (!customizer.isWSSFocused()) continue;
            return true;
        }
        return false;
    }

    public void register(PortCustomizer customizer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)customizer, (String)"PortCustomizer");
        if (this.customizers == null) {
            this.customizers = new HashSet<PortCustomizer>(7);
        }
        this.customizers.add(customizer);
    }

    public void unregister(PortCustomizer customizer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)customizer, (String)"PortCustomizer");
        if (this.customizers == null) {
            return;
        }
        this.customizers.remove(customizer);
    }
}

