/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Digits;

public class DigitsValidatorForString
implements ConstraintValidator<Digits, String> {
    private int maxIntegerLength;
    private int maxFractionLength;

    public void initialize(Digits constraintAnnotation) {
        this.maxIntegerLength = constraintAnnotation.integer();
        this.maxFractionLength = constraintAnnotation.fraction();
        this.validateParameters();
    }

    public boolean isValid(String str, ConstraintValidatorContext constraintValidatorContext) {
        if (str == null) {
            return true;
        }
        BigDecimal bigNum = this.getBigDecimalValue(str);
        if (bigNum == null) {
            return false;
        }
        int integerPartLength = bigNum.precision() - bigNum.scale();
        int fractionPartLength = bigNum.scale() < 0 ? 0 : bigNum.scale();
        return this.maxIntegerLength >= integerPartLength && this.maxFractionLength >= fractionPartLength;
    }

    private BigDecimal getBigDecimalValue(String str) {
        BigDecimal bd;
        try {
            bd = new BigDecimal(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return bd;
    }

    private void validateParameters() {
        if (this.maxIntegerLength < 0) {
            throw new IllegalArgumentException("The length of the integer part cannot be negative.");
        }
        if (this.maxFractionLength < 0) {
            throw new IllegalArgumentException("The length of the fraction part cannot be negative.");
        }
    }
}

