/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validator.engine.resolver.DefaultTraversableResolver;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.resourceloading.ResourceBundleLocator;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.Version;
import org.hibernate.validator.xml.ValidationBootstrapParameters;
import org.hibernate.validator.xml.ValidationXmlParser;
import org.slf4j.Logger;

public class ConfigurationImpl
implements HibernateValidatorConfiguration,
ConfigurationState {
    private static final Logger log;
    private final ResourceBundleLocator defaultResourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages");
    private final MessageInterpolator defaultMessageInterpolator = new ResourceBundleMessageInterpolator(this.defaultResourceBundleLocator);
    private final TraversableResolver defaultTraversableResolver = new DefaultTraversableResolver();
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory = new ConstraintValidatorFactoryImpl();
    private final ValidationProviderResolver providerResolver;
    private ValidationBootstrapParameters validationBootstrapParameters;
    private boolean ignoreXmlConfiguration = false;
    private Set<InputStream> configurationStreams = new HashSet<InputStream>();
    private ConstraintMapping mapping;
    private boolean failFast;

    public ConfigurationImpl(BootstrapState state) {
        this.providerResolver = state.getValidationProviderResolver() == null ? state.getDefaultValidationProviderResolver() : state.getValidationProviderResolver();
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
    }

    public ConfigurationImpl(ValidationProvider<?> provider) {
        if (provider == null) {
            throw new ValidationException("Assertion error: inconsistent ConfigurationImpl construction");
        }
        this.providerResolver = null;
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        this.validationBootstrapParameters.setProvider(provider);
    }

    public final HibernateValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    public final ConfigurationImpl messageInterpolator(MessageInterpolator interpolator) {
        this.validationBootstrapParameters.setMessageInterpolator(interpolator);
        return this;
    }

    public final ConfigurationImpl traversableResolver(TraversableResolver resolver) {
        this.validationBootstrapParameters.setTraversableResolver(resolver);
        return this;
    }

    public final ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.validationBootstrapParameters.setConstraintValidatorFactory(constraintValidatorFactory);
        return this;
    }

    public final HibernateValidatorConfiguration addMapping(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("The stream cannot be null.");
        }
        this.validationBootstrapParameters.addMapping(stream);
        return this;
    }

    @Override
    public final HibernateValidatorConfiguration failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public final HibernateValidatorConfiguration addMapping(ConstraintMapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("The mapping cannot be null.");
        }
        this.mapping = mapping;
        return this;
    }

    public final HibernateValidatorConfiguration addProperty(String name, String value) {
        if (value != null) {
            this.validationBootstrapParameters.addConfigProperty(name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ValidatorFactory buildValidatorFactory() {
        this.parseValidationXml();
        ValidatorFactory factory = null;
        try {
            if (this.isSpecificProvider()) {
                factory = this.validationBootstrapParameters.getProvider().buildValidatorFactory((ConfigurationState)this);
            } else {
                Class<ValidationProvider<?>> providerClass = this.validationBootstrapParameters.getProviderClass();
                if (providerClass != null) {
                    for (ValidationProvider provider : this.providerResolver.getValidationProviders()) {
                        if (!providerClass.isAssignableFrom(provider.getClass())) continue;
                        factory = provider.buildValidatorFactory((ConfigurationState)this);
                        break;
                    }
                    if (factory == null) {
                        throw new ValidationException("Unable to find provider: " + providerClass);
                    }
                } else {
                    List providers = this.providerResolver.getValidationProviders();
                    assert (providers.size() != 0);
                    factory = ((ValidationProvider)providers.get(0)).buildValidatorFactory((ConfigurationState)this);
                }
            }
        }
        finally {
            for (InputStream in : this.configurationStreams) {
                try {
                    in.close();
                }
                catch (IOException io) {
                    log.warn("Unable to close input stream.");
                }
            }
        }
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        return factory;
    }

    public final boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    public final MessageInterpolator getMessageInterpolator() {
        return this.validationBootstrapParameters.getMessageInterpolator();
    }

    public final Set<InputStream> getMappingStreams() {
        return this.validationBootstrapParameters.getMappings();
    }

    public final boolean getFailFast() {
        return this.failFast;
    }

    public final ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.validationBootstrapParameters.getConstraintValidatorFactory();
    }

    public final TraversableResolver getTraversableResolver() {
        return this.validationBootstrapParameters.getTraversableResolver();
    }

    public final Map<String, String> getProperties() {
        return this.validationBootstrapParameters.getConfigProperties();
    }

    public final MessageInterpolator getDefaultMessageInterpolator() {
        return this.defaultMessageInterpolator;
    }

    public final TraversableResolver getDefaultTraversableResolver() {
        return this.defaultTraversableResolver;
    }

    public final ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    @Override
    public final ResourceBundleLocator getDefaultResourceBundleLocator() {
        return this.defaultResourceBundleLocator;
    }

    public final ConstraintMapping getMapping() {
        return this.mapping;
    }

    private boolean isSpecificProvider() {
        return this.validationBootstrapParameters.getProvider() != null;
    }

    private void parseValidationXml() {
        if (this.ignoreXmlConfiguration) {
            log.info("Ignoring XML configuration.");
            if (this.validationBootstrapParameters.getMessageInterpolator() == null) {
                this.validationBootstrapParameters.setMessageInterpolator(this.defaultMessageInterpolator);
            }
            if (this.validationBootstrapParameters.getTraversableResolver() == null) {
                this.validationBootstrapParameters.setTraversableResolver(this.defaultTraversableResolver);
            }
            if (this.validationBootstrapParameters.getConstraintValidatorFactory() == null) {
                this.validationBootstrapParameters.setConstraintValidatorFactory(this.defaultConstraintValidatorFactory);
            }
        } else {
            ValidationBootstrapParameters xmlParameters = new ValidationXmlParser().parseValidationXml();
            this.applyXmlSettings(xmlParameters);
        }
    }

    private void applyXmlSettings(ValidationBootstrapParameters xmlParameters) {
        this.validationBootstrapParameters.setProviderClass(xmlParameters.getProviderClass());
        if (this.validationBootstrapParameters.getMessageInterpolator() == null) {
            if (xmlParameters.getMessageInterpolator() != null) {
                this.validationBootstrapParameters.setMessageInterpolator(xmlParameters.getMessageInterpolator());
            } else {
                this.validationBootstrapParameters.setMessageInterpolator(this.defaultMessageInterpolator);
            }
        }
        if (this.validationBootstrapParameters.getTraversableResolver() == null) {
            if (xmlParameters.getTraversableResolver() != null) {
                this.validationBootstrapParameters.setTraversableResolver(xmlParameters.getTraversableResolver());
            } else {
                this.validationBootstrapParameters.setTraversableResolver(this.defaultTraversableResolver);
            }
        }
        if (this.validationBootstrapParameters.getConstraintValidatorFactory() == null) {
            if (xmlParameters.getConstraintValidatorFactory() != null) {
                this.validationBootstrapParameters.setConstraintValidatorFactory(xmlParameters.getConstraintValidatorFactory());
            } else {
                this.validationBootstrapParameters.setConstraintValidatorFactory(this.defaultConstraintValidatorFactory);
            }
        }
        this.validationBootstrapParameters.addAllMappings(xmlParameters.getMappings());
        this.configurationStreams.addAll(xmlParameters.getMappings());
        for (Map.Entry<String, String> entry : xmlParameters.getConfigProperties().entrySet()) {
            if (this.validationBootstrapParameters.getConfigProperties().get(entry.getKey()) != null) continue;
            this.validationBootstrapParameters.addConfigProperty(entry.getKey(), entry.getValue());
        }
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

