/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.context.impl.ConfiguredConstraint;
import org.hibernate.validator.cfg.context.impl.ConstraintMappingContext;
import org.hibernate.validator.engine.ConfigurationImpl;
import org.hibernate.validator.engine.ValidatorContextImpl;
import org.hibernate.validator.metadata.AggregatedMethodMetaData;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.metadata.MethodMetaConstraint;
import org.hibernate.validator.metadata.MethodMetaData;
import org.hibernate.validator.metadata.ParameterMetaData;
import org.hibernate.validator.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.util.CollectionHelper;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.xml.XmlMappingParser;

public class ValidatorFactoryImpl
implements HibernateValidatorFactory {
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final ConstraintHelper constraintHelper;
    private final boolean failFast;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.constraintHelper = new ConstraintHelper();
        this.beanMetaDataCache = new BeanMetaDataCache();
        boolean tmpFailFast = false;
        if (!configurationState.getMappingStreams().isEmpty()) {
            this.initXmlConfiguration(configurationState.getMappingStreams());
        }
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateSpecificConfig = (ConfigurationImpl)configurationState;
            if (hibernateSpecificConfig.getMapping() != null) {
                this.initProgrammaticConfiguration(hibernateSpecificConfig.getMapping());
            }
            tmpFailFast = hibernateSpecificConfig.getFailFast();
        }
        this.failFast = tmpFailFast = this.checkPropertiesForFailFast(configurationState, tmpFailFast);
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public <T> T unwrap(Class<T> type) {
        if (HibernateValidatorFactory.class.equals(type)) {
            return type.cast(this);
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.constraintHelper, this.beanMetaDataCache, this.failFast);
    }

    private <T> void initProgrammaticConfiguration(ConstraintMapping mapping) {
        ConstraintMappingContext context = ConstraintMappingContext.getFromMapping(mapping);
        Map<Class<?>, List<ConfiguredConstraint<?, BeanConstraintLocation>>> constraintsByType = context.getConstraintConfig();
        Map<Class<?>, List<ConfiguredConstraint<?, MethodConstraintLocation>>> methodConstraintsByType = context.getMethodConstraintConfig();
        Map<Class<?>, List<BeanConstraintLocation>> cascadeConfigByType = context.getCascadeConfig();
        Map<Class<?>, List<MethodConstraintLocation>> methodCascadeConfigByType = context.getMethodCascadeConfig();
        Iterator<Class<?>> i$ = context.getConfiguredClasses().iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(beanClass, true);
            HashMap<Class<?>, List<BeanMetaConstraint<?>>> constraints = CollectionHelper.newHashMap();
            HashSet<AggregatedMethodMetaData.Builder> builders = CollectionHelper.newHashSet();
            HashSet<Member> cascadedMembers = CollectionHelper.newHashSet();
            for (Class<?> classInHierarchy : classes) {
                List<MethodConstraintLocation> methodCascadesOfType;
                List<BeanConstraintLocation> cascadesOfType;
                List<ConfiguredConstraint<?, MethodConstraintLocation>> methodConstraintsOfType;
                List<ConfiguredConstraint<?, BeanConstraintLocation>> constraintsOfType = constraintsByType.get(classInHierarchy);
                if (constraintsOfType != null) {
                    this.addProgrammaticConfiguredConstraints(constraintsOfType, beanClass, classInHierarchy, constraints);
                }
                if ((methodConstraintsOfType = methodConstraintsByType.get(classInHierarchy)) != null) {
                    this.addProgrammaticConfiguredMethodConstraint(methodConstraintsOfType, beanClass, classInHierarchy, builders);
                }
                if ((cascadesOfType = cascadeConfigByType.get(classInHierarchy)) != null) {
                    this.addProgrammaticConfiguredCascade(cascadesOfType, cascadedMembers);
                }
                if ((methodCascadesOfType = methodCascadeConfigByType.get(classInHierarchy)) == null) continue;
                this.addProgrammaticConfiguredMethodCascade(methodCascadesOfType, builders);
            }
            HashSet<AggregatedMethodMetaData> methodMetaDataMap = CollectionHelper.newHashSet();
            for (AggregatedMethodMetaData.Builder oneBuilder : builders) {
                methodMetaDataMap.add(oneBuilder.build());
            }
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, context.getDefaultSequence(beanClass), context.getDefaultGroupSequenceProvider(beanClass), constraints, methodMetaDataMap, cascadedMembers, new AnnotationIgnores(), this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }

    private <T> void initXmlConfiguration(Set<InputStream> mappingStreams) {
        XmlMappingParser mappingParser = new XmlMappingParser(this.constraintHelper);
        mappingParser.parse(mappingStreams);
        Set<Class<?>> xmlConfiguredClasses = mappingParser.getXmlConfiguredClasses();
        AnnotationIgnores annotationIgnores = mappingParser.getAnnotationIgnores();
        Iterator<Class<?>> i$ = xmlConfiguredClasses.iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(beanClass, true);
            HashMap<Class<?>, List<BeanMetaConstraint<?>>> constraints = CollectionHelper.newHashMap();
            HashSet<Member> cascadedMembers = CollectionHelper.newHashSet();
            for (Class<?> classInHierarchy : classes) {
                if (!xmlConfiguredClasses.contains(classInHierarchy)) continue;
                this.addXmlConfiguredConstraints(mappingParser, beanClass, classInHierarchy, constraints);
                this.addXmlCascadedMember(mappingParser, classInHierarchy, cascadedMembers);
            }
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, mappingParser.getDefaultSequenceForClass(beanClass), null, constraints, Collections.<AggregatedMethodMetaData>emptySet(), cascadedMembers, annotationIgnores, this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }

    private <T, A extends Annotation> void addXmlConfiguredConstraints(XmlMappingParser mappingParser, Class<T> rootClass, Class<?> hierarchyClass, Map<Class<?>, List<BeanMetaConstraint<?>>> constraints) {
        for (BeanMetaConstraint<?> constraint : mappingParser.getConstraintsForClass(hierarchyClass)) {
            ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
            ConstraintDescriptorImpl descriptor = new ConstraintDescriptorImpl(constraint.getDescriptor().getAnnotation(), this.constraintHelper, constraint.getElementType(), definedIn);
            BeanMetaConstraint newMetaConstraint = new BeanMetaConstraint(descriptor, constraint.getLocation().getBeanClass(), constraint.getLocation().getMember());
            this.addConstraintToMap(hierarchyClass, newMetaConstraint, constraints);
        }
    }

    private <T, A extends Annotation> void addProgrammaticConfiguredConstraints(List<ConfiguredConstraint<?, BeanConstraintLocation>> definitions, Class<T> rootClass, Class<?> hierarchyClass, Map<Class<?>, List<BeanMetaConstraint<?>>> constraints) {
        for (ConfiguredConstraint<?, BeanConstraintLocation> config : definitions) {
            Object annotation = this.createAnnotationProxy(config);
            ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
            ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(annotation, this.constraintHelper, config.getLocation().getElementType(), definedIn);
            Member member = config.getLocation().getMember();
            BeanMetaConstraint metaConstraint = new BeanMetaConstraint(constraintDescriptor, config.getLocation().getBeanClass(), member);
            this.addConstraintToMap(hierarchyClass, metaConstraint, constraints);
        }
    }

    private <M extends MetaConstraint<?>> void addConstraintToMap(Class<?> hierarchyClass, M constraint, Map<Class<?>, List<M>> constraints) {
        List<M> constraintList = constraints.get(hierarchyClass);
        if (constraintList == null) {
            constraintList = CollectionHelper.newArrayList();
            constraints.put(hierarchyClass, constraintList);
        }
        constraintList.add(constraint);
    }

    private void addXmlCascadedMember(XmlMappingParser mappingParser, Class<?> hierarchyClass, Set<Member> cascadedMembers) {
        for (Member m : mappingParser.getCascadedMembersForClass(hierarchyClass)) {
            cascadedMembers.add(m);
        }
    }

    private void addProgrammaticConfiguredCascade(List<BeanConstraintLocation> cascades, Set<Member> cascadedMembers) {
        for (BeanConstraintLocation cascade : cascades) {
            cascadedMembers.add(cascade.getMember());
        }
    }

    private <T> void addProgrammaticConfiguredMethodConstraint(List<ConfiguredConstraint<?, MethodConstraintLocation>> methodConstraints, Class<T> rootClass, Class<?> hierarchyClass, Set<AggregatedMethodMetaData.Builder> builders) {
        Map<Method, List<ConfiguredConstraint<?, MethodConstraintLocation>>> constraintsByMethod = CollectionHelper.partition(methodConstraints, this.byMethod());
        for (Map.Entry<Method, List<ConfiguredConstraint<?, MethodConstraintLocation>>> oneMethod : constraintsByMethod.entrySet()) {
            MethodMetaData methodMetaData = this.createMethodMetaData(oneMethod.getKey(), oneMethod.getValue(), rootClass, hierarchyClass);
            this.addMetaDataToBuilder(methodMetaData, builders);
        }
    }

    private void addProgrammaticConfiguredMethodCascade(List<MethodConstraintLocation> methodCascades, Set<AggregatedMethodMetaData.Builder> builders) {
        for (MethodConstraintLocation cascadeDef : methodCascades) {
            MethodMetaData methodMetaData = this.createMethodMetaData(cascadeDef);
            this.addMetaDataToBuilder(methodMetaData, builders);
        }
    }

    private MethodMetaData createMethodMetaData(MethodConstraintLocation cascadeDef) {
        Method method = cascadeDef.getMethod();
        ArrayList<ParameterMetaData> parameterMetaDatas = CollectionHelper.newArrayList();
        List<MethodMetaConstraint<?>> parameterConstraints = Collections.emptyList();
        List<MethodMetaConstraint<?>> returnConstraints = Collections.emptyList();
        int i = 0;
        for (Class<?> parameterType : method.getParameterTypes()) {
            String parameterName = "arg" + i;
            boolean isCascading = Integer.valueOf(i).equals(cascadeDef.getParameterIndex());
            parameterMetaDatas.add(new ParameterMetaData(i, parameterType, parameterName, parameterConstraints, isCascading));
            ++i;
        }
        boolean isCascading = cascadeDef.getParameterIndex() == null;
        return new MethodMetaData(method, parameterMetaDatas, returnConstraints, isCascading);
    }

    private MethodMetaData createMethodMetaData(Method method, List<ConfiguredConstraint<?, MethodConstraintLocation>> constraints, Class<?> rootClass, Class<?> hierarchyClass) {
        Map<Integer, List<ConfiguredConstraint<?, MethodConstraintLocation>>> constraintsByIndex = CollectionHelper.partition(constraints, this.byParameterIndex());
        ArrayList<ParameterMetaData> allParameterMetaData = CollectionHelper.newArrayList(method.getParameterTypes().length);
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            allParameterMetaData.add(new ParameterMetaData(i, method.getParameterTypes()[i], "arg" + i, this.convertToMethodConstraints(constraintsByIndex.get(i), rootClass, hierarchyClass), false));
        }
        List<MethodMetaConstraint<?>> returnValueConstraints = this.convertToMethodConstraints(constraintsByIndex.get(null), rootClass, hierarchyClass);
        return new MethodMetaData(method, allParameterMetaData, returnValueConstraints, false);
    }

    private List<MethodMetaConstraint<?>> convertToMethodConstraints(List<ConfiguredConstraint<?, MethodConstraintLocation>> configuredConstraints, Class<?> rootClass, Class<?> hierarchyClass) {
        if (configuredConstraints == null) {
            configuredConstraints = Collections.emptyList();
        }
        ArrayList<MethodMetaConstraint<?>> theValue = CollectionHelper.newArrayList();
        for (ConfiguredConstraint<Object, MethodConstraintLocation> oneConfiguredConstraint : configuredConstraints) {
            theValue.add(this.convertToMethodConstraint(oneConfiguredConstraint, rootClass, hierarchyClass));
        }
        return theValue;
    }

    private <A extends Annotation> MethodMetaConstraint<A> convertToMethodConstraint(ConfiguredConstraint<A, MethodConstraintLocation> configuredConstraint, Class<?> rootClass, Class<?> hierarchyClass) {
        A annotation = this.createAnnotationProxy(configuredConstraint);
        ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
        ConstraintDescriptorImpl<A> constraintDescriptor = new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, ElementType.PARAMETER, definedIn);
        return new MethodMetaConstraint<A>(constraintDescriptor, configuredConstraint.getLocation());
    }

    private void addMetaDataToBuilder(MethodMetaData methodMetaData, Set<AggregatedMethodMetaData.Builder> builders) {
        for (AggregatedMethodMetaData.Builder OneBuilder : builders) {
            if (!OneBuilder.accepts(methodMetaData)) continue;
            OneBuilder.addMetaData(methodMetaData);
            return;
        }
        AggregatedMethodMetaData.Builder builder = new AggregatedMethodMetaData.Builder(methodMetaData);
        builders.add(builder);
    }

    private ConstraintOrigin definedIn(Class<?> rootClass, Class<?> hierarchyClass) {
        if (hierarchyClass.equals(rootClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }

    private <A extends Annotation> A createAnnotationProxy(ConfiguredConstraint<A, ?> config) {
        A annotation;
        Class<A> constraintType = config.getConstraintType();
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(constraintType);
        for (Map.Entry<String, Object> parameter : config.getParameters().entrySet()) {
            annotationDescriptor.setValue(parameter.getKey(), parameter.getValue());
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to create annotation for configured constraint: " + e.getMessage(), (Throwable)e);
        }
        return annotation;
    }

    private boolean checkPropertiesForFailFast(ConfigurationState configurationState, boolean programmaticConfiguredFailFast) {
        boolean failFast = programmaticConfiguredFailFast;
        String failFastPropValue = (String)configurationState.getProperties().get("hibernate.validator.fail_fast");
        if (failFastPropValue != null) {
            boolean tmpFailFast = Boolean.valueOf(failFastPropValue);
            if (programmaticConfiguredFailFast && !tmpFailFast) {
                throw new ValidationException("Inconsistent fail fast configuration. Fail fast enabled via programmatic API, but explicitly disabled via properties");
            }
            failFast = tmpFailFast;
        }
        return failFast;
    }

    private CollectionHelper.Partitioner<Method, ConfiguredConstraint<?, MethodConstraintLocation>> byMethod() {
        return new CollectionHelper.Partitioner<Method, ConfiguredConstraint<?, MethodConstraintLocation>>(){

            @Override
            public Method getPartition(ConfiguredConstraint<?, MethodConstraintLocation> v) {
                return v.getLocation().getMethod();
            }
        };
    }

    private CollectionHelper.Partitioner<Integer, ConfiguredConstraint<?, MethodConstraintLocation>> byParameterIndex() {
        return new CollectionHelper.Partitioner<Integer, ConfiguredConstraint<?, MethodConstraintLocation>>(){

            @Override
            public Integer getPartition(ConfiguredConstraint<?, MethodConstraintLocation> v) {
                return v.getLocation().getParameterIndex();
            }
        };
    }
}

