/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine.resolver;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ReflectionHelper;
import org.slf4j.Logger;

public class DefaultTraversableResolver
implements TraversableResolver {
    private static final Logger log = LoggerFactory.make();
    private static final String PERSISTENCE_CLASS_NAME = "javax.persistence.Persistence";
    private static final String PERSISTENCE_UTIL_METHOD = "getPersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME = "org.hibernate.validator.engine.resolver.JPATraversableResolver";
    private TraversableResolver jpaTraversableResolver;

    public DefaultTraversableResolver() {
        this.detectJPA();
    }

    private void detectJPA() {
        Class<?> persistenceClass;
        try {
            persistenceClass = ReflectionHelper.loadClass(PERSISTENCE_CLASS_NAME, this.getClass());
        }
        catch (ValidationException e) {
            log.debug("Cannot find {} on classpath. Assuming non JPA 2 environment. All properties will per default be traversable.", (Object)PERSISTENCE_CLASS_NAME);
            return;
        }
        Method persistenceUtilGetter = ReflectionHelper.getMethod(persistenceClass, PERSISTENCE_UTIL_METHOD);
        if (persistenceUtilGetter == null) {
            log.debug("Found {} on classpath, but no method '{}'. Assuming JPA 1 environment. All properties will per default be traversable.", (Object)PERSISTENCE_CLASS_NAME, (Object)PERSISTENCE_UTIL_METHOD);
            return;
        }
        try {
            Object persistence = ReflectionHelper.newInstance(persistenceClass, "persistence provider");
            ReflectionHelper.getValue(persistenceUtilGetter, persistence);
        }
        catch (Exception e) {
            log.debug("Unable to invoke {}.{}. Inconsistent JPA environment. All properties will per default be traversable.", (Object)PERSISTENCE_CLASS_NAME, (Object)PERSISTENCE_UTIL_METHOD);
        }
        log.debug("Found {} on classpath containing '{}'. Assuming JPA 2 environment. Trying to instantiate JPA aware TraversableResolver", (Object)PERSISTENCE_CLASS_NAME, (Object)PERSISTENCE_UTIL_METHOD);
        try {
            Class<?> jpaAwareResolverClass = ReflectionHelper.loadClass(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME, this.getClass());
            this.jpaTraversableResolver = (TraversableResolver)ReflectionHelper.newInstance(jpaAwareResolverClass, "");
            log.debug("Instantiated JPA aware TraversableResolver of type {}.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
        catch (ValidationException e) {
            log.debug("Unable to load or instantiate JPA aware resolver {}. All properties will per default be traversable.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTraversableResolver == null || this.jpaTraversableResolver.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTraversableResolver == null || this.jpaTraversableResolver.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }
}

