/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata.location;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.validator.metadata.location.ConstraintLocation;
import org.hibernate.validator.util.ReflectionHelper;

public class BeanConstraintLocation
implements ConstraintLocation {
    private final Member member;
    private final String propertyName;
    private final Class<?> beanClass;
    private final ElementType elementType;

    public BeanConstraintLocation(Class<?> beanClass) {
        this(beanClass, null);
    }

    public BeanConstraintLocation(Class<?> beanClass, Member member) {
        this.member = member;
        if (this.member != null) {
            this.propertyName = ReflectionHelper.getPropertyName(member);
            this.elementType = member instanceof Method ? ElementType.METHOD : ElementType.FIELD;
        } else {
            this.propertyName = null;
            this.elementType = ElementType.TYPE;
        }
        this.beanClass = beanClass;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Member getMember() {
        return this.member;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Type typeOfAnnotatedElement() {
        Type t;
        if (this.member == null) {
            t = this.beanClass;
        } else {
            t = ReflectionHelper.typeOf(this.member);
            if (t instanceof Class && ((Class)t).isPrimitive()) {
                t = ReflectionHelper.boxedType(t);
            }
        }
        return t;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanConstraintLocation that = (BeanConstraintLocation)o;
        if (this.beanClass != null ? !this.beanClass.equals(that.beanClass) : that.beanClass != null) {
            return false;
        }
        if (this.member != null ? !this.member.equals(that.member) : that.member != null) {
            return false;
        }
        return !(this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null);
    }

    public int hashCode() {
        int result = this.member != null ? this.member.hashCode() : 0;
        result = 31 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        result = 31 * result + (this.beanClass != null ? this.beanClass.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanConstraintLocation");
        sb.append("{beanClass=").append(this.beanClass.getSimpleName());
        sb.append(", propertyName='").append(this.propertyName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

