/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.registry;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.invoker.BatchCacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

@Listener(sync=false)
public class RegistryService<K, V>
implements Service<Registry<K, V>>,
Registry<K, V> {
    static final Address LOCAL_ADDRESS = new Address(){};
    private final CacheInvoker invoker = new BatchCacheInvoker();
    private final Value<Cache<Address, Map.Entry<K, V>>> cache;
    private final Value<Registry.RegistryEntryProvider<K, V>> provider;
    private final Set<Registry.Listener<K, V>> listeners = new CopyOnWriteArraySet<Registry.Listener<K, V>>();
    private ThreadLocal<Map.Entry<K, V>> entry = new ThreadLocal();

    public RegistryService(Value<Cache<Address, Map.Entry<K, V>>> cache, Value<Registry.RegistryEntryProvider<K, V>> provider) {
        this.cache = cache;
        this.provider = provider;
    }

    public Registry<K, V> getValue() {
        return this;
    }

    @Override
    public String getName() {
        return ((Cache)this.cache.getValue()).getCacheManager().getClusterName();
    }

    @Override
    public void addListener(Registry.Listener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Registry.Listener<K, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Map<K, V> getEntries() {
        HashMap map = new HashMap();
        for (Map.Entry entry : ((Cache)this.cache.getValue()).values()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Map.Entry<K, V> getLocalEntry() {
        Cache cache = (Cache)this.cache.getValue();
        return (Map.Entry)cache.get((Object)RegistryService.getLocalAddress(cache));
    }

    @Override
    public Map.Entry<K, V> getRemoteEntry(Object address) {
        return (Map.Entry)((Cache)this.cache.getValue()).get(address);
    }

    public void start(StartContext context) {
        this.refreshLocalEntry();
        Cache cache = (Cache)this.cache.getValue();
        cache.getCacheManager().addListener((Object)this);
        cache.addListener((Object)this);
    }

    @Override
    public Map.Entry<K, V> refreshLocalEntry() {
        final Map.Entry<K, V> entry = this.createLocalCacheEntry();
        if (entry != null) {
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<Address, Map.Entry<K, V>> cache) {
                    RegistryService.this.addLocalCacheEntry(cache, entry);
                    return null;
                }
            };
            this.invoker.invoke((Cache)this.cache.getValue(), (CacheInvoker.Operation)operation, new Flag[0]);
        }
        return entry;
    }

    void addLocalCacheEntry(Cache<Address, Map.Entry<K, V>> cache, Map.Entry<K, V> entry) {
        if (entry != null) {
            cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)RegistryService.getLocalAddress(cache), entry);
        }
    }

    Map.Entry<K, V> createLocalCacheEntry() {
        Registry.RegistryEntryProvider provider = (Registry.RegistryEntryProvider)this.provider.getValue();
        Object key = provider.getKey();
        return key != null ? new AbstractMap.SimpleImmutableEntry(key, provider.getValue()) : null;
    }

    public void stop(StopContext context) {
        Cache cache = (Cache)this.cache.getValue();
        cache.removeListener((Object)this);
        cache.getCacheManager().removeListener((Object)this);
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<Address, Map.Entry<K, V>> cache) {
                cache.remove((Object)RegistryService.getLocalAddress(cache));
                return null;
            }
        };
        this.invoker.invoke((Cache)this.cache.getValue(), (CacheInvoker.Operation)operation, new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING});
    }

    static Address getLocalAddress(Cache<?, ?> cache) {
        Address address = cache.getCacheManager().getAddress();
        return address != null ? address : LOCAL_ADDRESS;
    }

    @ViewChanged
    public void viewChanged(final ViewChangedEvent event) {
        Operation operation = new Operation<Set<K>>(){

            public Set<K> invoke(Cache<Address, Map.Entry<K, V>> cache) {
                List oldMembers = event.getOldMembers();
                List newMembers = event.getNewMembers();
                HashSet removed = new HashSet();
                for (Address member : oldMembers) {
                    Map.Entry old;
                    if (newMembers.contains(member) || (old = (Map.Entry)cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).remove((Object)member)) == null) continue;
                    removed.add(old.getKey());
                }
                if (event.isMergeView()) {
                    RegistryService.this.addLocalCacheEntry(cache, RegistryService.this.createLocalCacheEntry());
                }
                return removed;
            }
        };
        Set removed = (Set)this.invoker.invoke((Cache)this.cache.getValue(), (CacheInvoker.Operation)operation, new Flag[0]);
        if (!removed.isEmpty()) {
            for (Registry.Listener<K, V> listener : this.listeners) {
                listener.removedEntries(removed);
            }
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<Address, Map.Entry<K, V>> event) {
        if (event.isOriginLocal()) {
            return;
        }
        if (event.isPre()) {
            this.entry.set((Map.Entry<K, V>)event.getValue());
        } else {
            Map.Entry entry;
            Map.Entry<K, V> old = this.entry.get();
            this.entry.remove();
            if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getValue()) != null) {
                Map entries = Collections.singletonMap(entry.getKey(), entry.getValue());
                for (Registry.Listener listener : this.listeners) {
                    if (old == null) {
                        listener.addedEntries(entries);
                        continue;
                    }
                    listener.updatedEntries(entries);
                }
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<Address, Map.Entry<K, V>> event) {
        if (event.isOriginLocal()) {
            return;
        }
        if (event.isPre()) {
            this.entry.set((Map.Entry<K, V>)event.getValue());
        } else {
            Map.Entry<K, V> entry = this.entry.get();
            this.entry.remove();
            if (entry != null) {
                Set<K> keys = Collections.singleton(entry.getKey());
                for (Registry.Listener<K, V> listener : this.listeners) {
                    listener.removedEntries(keys);
                }
            }
        }
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<Address, Map.Entry<K, V>, R> {
        Operation() {
        }
    }
}

