/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.gatein.common.io.UndeclaredIOException;
import org.gatein.common.servlet.ServletOutputStreamBuffer;

public class BufferingResponseWrapper
extends HttpServletResponseWrapper {
    private ServletOutputStreamBuffer outputStream;
    private PrintWriter writer;
    private StringWriter chars;
    private String characterEncoding;
    protected int bufferSize;

    public BufferingResponseWrapper(HttpServletResponse response) {
        super(response);
        this.characterEncoding = response.getCharacterEncoding();
        this.bufferSize = 0;
    }

    public String getContent() {
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                return this.outputStream.getContent(this.characterEncoding);
            }
            catch (IOException e) {
                throw new UndeclaredIOException(e);
            }
        }
        if (this.chars != null) {
            this.writer.flush();
            return this.chars.toString();
        }
        return null;
    }

    public void addCookie(Cookie arg0) {
    }

    public void addDateHeader(String arg0, long arg1) {
    }

    public void addHeader(String arg0, String arg1) {
    }

    public void addIntHeader(String arg0, int arg1) {
    }

    public void sendError(int arg0) throws IOException {
    }

    public void sendError(int arg0, String arg1) throws IOException {
    }

    public void sendRedirect(String arg0) throws IOException {
    }

    public void setDateHeader(String arg0, long arg1) {
    }

    public void setHeader(String arg0, String arg1) {
    }

    public void setIntHeader(String arg0, int arg1) {
    }

    public void setStatus(int arg0) {
    }

    public void setStatus(int arg0, String arg1) {
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("Already obtained a PrintWriter");
        }
        if (this.outputStream == null) {
            this.outputStream = new ServletOutputStreamBuffer(500);
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("Already obtained a ServletOutputStream");
        }
        if (this.writer == null) {
            this.chars = new StringWriter();
            this.writer = new PrintWriter((Writer)this.chars, false);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.outputStream != null) {
            this.outputStream.reset();
        } else if (this.chars != null) {
            this.writer.flush();
            this.chars.getBuffer().setLength(0);
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentLength(int arg0) {
    }

    public void setContentType(String arg0) {
    }

    public void setLocale(Locale arg0) {
    }
}

