/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.util.Base64;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.WSTimeoutException;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.client.ssl.SSLContextFactory;
import org.jboss.ws.core.client.transport.NettyHelper;
import org.jboss.ws.core.client.transport.NettyTransportHandler;
import org.jboss.ws.core.client.transport.NettyTransportOutputStream;
import org.jboss.ws.core.client.transport.WSResponseHandler;

public class NettyClient {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NettyClient.class);
    public static final String RESPONSE_CODE = "org.jboss.ws.core.client.transport.NettyClient#ResponseCode";
    public static final String RESPONSE_CODE_MESSAGE = "org.jboss.ws.core.client.transport.NettyClient#ResponseCodeMessage";
    public static final String PROTOCOL = "org.jboss.ws.core.client.transport.NettyClient#Protocol";
    public static final String RESPONSE_HEADERS = "org.jboss.ws.core.client.transport.NettyClient#ResponseHeaders";
    private static Logger log = Logger.getLogger(NettyClient.class);
    private Marshaller marshaller;
    private UnMarshaller unmarshaller;
    private Long timeout;
    private Long connectionTimeout;
    private Long receiveTimeout;
    private static final int DEFAULT_CHUNK_SIZE = 1024;
    private Integer chunkSize = new Integer(1024);
    private static final Pattern headerCleanerPattern = Pattern.compile("[\r\n\f]");

    public NettyClient(Marshaller marshaller, UnMarshaller unmarshaller) {
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public Object invoke(Object reqMessage, String targetAddress, boolean oneway, Map<String, Object> additionalHeaders, Map<String, Object> callProps) throws IOException {
        try {
            return this.invokeInternal(reqMessage, targetAddress, oneway, additionalHeaders, callProps);
        }
        catch (ClosedChannelException cce) {
            if (NettyTransportHandler.getHttpKeepAliveSet()) {
                log.info((Object)"Retrying with a new connection...");
                return this.invokeInternal(reqMessage, targetAddress, oneway, additionalHeaders, callProps);
            }
            throw cce;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeInternal(Object reqMessage, String targetAddress, boolean oneway, Map<String, Object> additionalHeaders, Map<String, Object> callProps) throws IOException {
        Object object;
        Map<String, Object> resMetadata;
        HashMap<String, Object> resHeaders;
        NettyTransportHandler transport;
        block26: {
            URL target;
            try {
                target = new URL(targetAddress);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_ADDRESS", (Object[])new Object[]{targetAddress}), e);
            }
            transport = NettyTransportHandler.getInstance(target, NettyHelper.getChannelPipelineFactory(NettyClient.getSSLHandler(target, callProps)));
            Channel channel = null;
            resHeaders = null;
            resMetadata = null;
            try {
                this.setActualTimeout(callProps);
                if (callProps.containsKey("javax.xml.ws.client.connectionTimeout")) {
                    this.connectionTimeout = new Long(callProps.get("javax.xml.ws.client.connectionTimeout").toString());
                } else if (this.timeout != null) {
                    this.connectionTimeout = this.timeout;
                }
                channel = transport.getChannel(this.connectionTimeout);
                WSResponseHandler responseHandler = new WSResponseHandler();
                NettyHelper.setResponseHandler(channel, responseHandler);
                String targetRequestUri = NettyClient.isProxyRequest(additionalHeaders) ? targetAddress : NettyClient.getRelativeRequestUri(target);
                DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, reqMessage != null ? HttpMethod.POST : HttpMethod.GET, targetRequestUri);
                request.addHeader("Host", (Object)target.getAuthority());
                request.addHeader("Connection", (Object)"keep-alive");
                this.setAdditionalHeaders((HttpMessage)request, additionalHeaders);
                this.setActualChunkedLength((HttpRequest)request, callProps);
                this.setAuthorization((HttpMessage)request, callProps);
                ChannelFuture writeFuture = null;
                writeFuture = this.writeRequest(channel, (HttpRequest)request, reqMessage);
                if (writeFuture != null) {
                    writeFuture.awaitUninterruptibly();
                }
                Future<WSResponseHandler.Result> futureResult = responseHandler.getFutureResult();
                WSResponseHandler.Result result = null;
                if (callProps.containsKey("javax.xml.ws.client.receiveTimeout")) {
                    this.receiveTimeout = new Long(callProps.get("javax.xml.ws.client.receiveTimeout").toString());
                } else if (this.timeout != null) {
                    this.receiveTimeout = this.timeout;
                }
                try {
                    result = this.receiveTimeout == null ? futureResult.get() : futureResult.get(this.receiveTimeout, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException ee) {
                    Throwable throwable;
                    Throwable t = ee.getCause();
                    if (t != null) {
                        throwable = t;
                        throw throwable;
                    }
                    throwable = ee;
                    throw throwable;
                }
                catch (TimeoutException te) {
                    long l;
                    String string = BundleUtils.getMessage((ResourceBundle)bundle, (String)"RECEIVE_TIMEOUT", (Object[])new Object[0]);
                    if (this.receiveTimeout == null) {
                        l = -1L;
                        throw new WSTimeoutException(string, l);
                    }
                    l = this.receiveTimeout;
                    throw new WSTimeoutException(string, l);
                }
                resHeaders = result.getResponseHeaders();
                resMetadata = result.getMetadata();
                Object resMessage = oneway ? null : this.unmarshaller.read(result.getResponse(), resMetadata, resHeaders);
                callProps.clear();
                callProps.put(RESPONSE_HEADERS, resHeaders != null ? resHeaders : new HashMap<String, Object>());
                if (resMetadata != null) {
                    callProps.putAll(resMetadata);
                }
                object = resMessage;
                if (channel == null) break block26;
            }
            catch (ClosedChannelException cce) {
                try {
                    log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CHANNEL_CLOSED", (Object[])new Object[0]));
                    transport.end();
                    throw cce;
                    catch (ConnectException ce) {
                        transport.end();
                        throw ce;
                    }
                    catch (TimeoutException te) {
                        long l;
                        String string = BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONNECTION_TIMEOUT", (Object[])new Object[0]);
                        if (this.connectionTimeout == null) {
                            l = -1L;
                            throw new WSTimeoutException(string, l);
                        }
                        l = this.connectionTimeout;
                        throw new WSTimeoutException(string, l);
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (WSTimeoutException toe) {
                        throw toe;
                    }
                    catch (Throwable t) {
                        IOException io = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_TRANSMIT_MESSAGE", (Object[])new Object[0]));
                        io.initCause(t);
                        transport.end();
                        throw io;
                    }
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        NettyHelper.clearResponseHandler(channel);
                    }
                    transport.finished(resMetadata, resHeaders);
                    throw throwable;
                }
            }
            NettyHelper.clearResponseHandler(channel);
        }
        transport.finished(resMetadata, resHeaders);
        return object;
    }

    private static boolean isProxyRequest(Map<String, Object> additionalHeaders) {
        return additionalHeaders.containsKey("Proxy-Authorization");
    }

    private static String getRelativeRequestUri(URL target) {
        return target.getPath() + (target.getQuery() != null ? "?" + target.getQuery() : "") + (target.getRef() != null ? "#" + target.getRef() : "");
    }

    private static SslHandler getSSLHandler(URL target, Map<String, Object> callProps) throws IOException {
        SslHandler handler = null;
        if ("https".equalsIgnoreCase(target.getProtocol())) {
            SSLContextFactory sslContextFactory = new SSLContextFactory(callProps);
            SSLEngine engine = sslContextFactory.getSSLContext().createSSLEngine();
            engine.setUseClientMode(true);
            handler = new SslHandler(engine);
        }
        return handler;
    }

    private ChannelFuture writeRequest(Channel channel, HttpRequest request, Object reqMessage) throws IOException {
        if (reqMessage == null) {
            return channel.write((Object)request);
        }
        int cs = this.chunkSize;
        if (cs > 0) {
            request.addHeader("Transfer-Encoding", (Object)"chunked");
            channel.write((Object)request);
            NettyTransportOutputStream os = new NettyTransportOutputStream(channel, cs);
            this.marshaller.write(reqMessage, os);
            os.flush();
            os.close();
            return os.getChannelFuture();
        }
        ChannelBuffer content = ChannelBuffers.dynamicBuffer();
        ChannelBufferOutputStream os = new ChannelBufferOutputStream(content);
        this.marshaller.write(reqMessage, (OutputStream)os);
        os.flush();
        request.setHeader("Content-Length", (Object)String.valueOf(content.readableBytes()));
        request.setContent(content);
        return channel.write((Object)request);
    }

    protected void setActualChunkedLength(HttpRequest message, Map<String, Object> callProps) {
        if (HttpMethod.POST.equals((Object)message.getMethod())) {
            try {
                Object obj = callProps.get("http://org.jboss.ws/http#chunksize");
                if (obj != null) {
                    this.chunkSize = (Integer)obj;
                }
            }
            catch (Exception e) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CAN_NOT_SET_CHUNK_SIZE", (Object[])new Object[0]));
            }
        }
    }

    protected void setActualTimeout(Map<String, Object> callProps) {
        if (callProps.containsKey("org.jboss.ws.timeout")) {
            this.timeout = new Long(callProps.get("org.jboss.ws.timeout").toString());
        }
    }

    protected void setAuthorization(HttpMessage message, Map<String, Object> callProps) throws IOException {
        String authType = (String)callProps.get("org.jboss.ws.authType");
        if (authType == null) {
            authType = "org.jboss.ws.authType.basic";
        }
        String username = (String)callProps.get("javax.xml.rpc.security.auth.username");
        String password = (String)callProps.get("javax.xml.rpc.security.auth.password");
        if (username != null && password != null && authType.equals("org.jboss.ws.authType.basic")) {
            message.addHeader("Authorization", (Object)NettyClient.getBasicAuthHeader(username, password));
        }
    }

    private static String getBasicAuthHeader(String username, String password) throws IOException {
        return "Basic " + new String(Base64.encodeBytes((byte[])(username + ":" + password).getBytes("ISO-8859-1"), (int)8));
    }

    protected void setAdditionalHeaders(HttpMessage message, Map<String, Object> headers) {
        for (String key : headers.keySet()) {
            String header = (String)headers.get(key);
            message.addHeader(key, (Object)headerCleanerPattern.matcher(header).replaceAll(" "));
        }
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }
}

