/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import org.jboss.logging.Logger;
import org.jboss.ws.core.RoleSource;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.ServerHandlerChain;
import org.jboss.ws.core.server.ServerHandlerDelegate;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;

public class HandlerDelegateJAXRPC
extends ServerHandlerDelegate
implements RoleSource {
    private static Logger log = Logger.getLogger(HandlerDelegateJAXRPC.class);
    private ServerHandlerChain preHandlerChain;
    private ServerHandlerChain jaxrpcHandlerChain;
    private ServerHandlerChain postHandlerChain;
    Set<QName> headers = new HashSet<QName>();
    Set<String> roles = new HashSet<String>();

    public HandlerDelegateJAXRPC(ServerEndpointMetaData sepMetaData) {
        super(sepMetaData);
    }

    @Override
    public UnifiedHandlerMetaData.HandlerType[] getHandlerTypeOrder() {
        return new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        if (!this.isInitialized()) {
            ServerEndpointMetaData serverEndpointMetaData = sepMetaData;
            synchronized (serverEndpointMetaData) {
                if (!this.isInitialized()) {
                    this.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.PRE);
                    this.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                    this.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.POST);
                    this.setInitialized(true);
                }
            }
        }
        boolean status = true;
        ServerHandlerChain handlerChain = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChain = this.preHandlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            handlerChain = this.jaxrpcHandlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChain = this.postHandlerChain;
        }
        if (handlerChain != null) {
            status = handlerChain.handleRequest(msgContext);
        }
        return status;
    }

    @Override
    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        ServerHandlerChain handlerChain = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChain = this.preHandlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            handlerChain = this.jaxrpcHandlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChain = this.postHandlerChain;
        }
        return handlerChain != null ? handlerChain.handleResponse(msgContext) : true;
    }

    @Override
    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        ServerHandlerChain handlerChain = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChain = this.preHandlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            handlerChain = this.jaxrpcHandlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChain = this.postHandlerChain;
        }
        return handlerChain != null ? handlerChain.handleFault(msgContext) : true;
    }

    @Override
    public void closeHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
    }

    private void initHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        HashSet<String> handlerRoles = new HashSet<String>();
        ArrayList<HandlerInfo> hInfos = new ArrayList<HandlerInfo>();
        for (HandlerMetaData handlerMetaData : sepMetaData.getHandlerMetaData(type)) {
            HandlerMetaDataJAXRPC jaxrpcMetaData = (HandlerMetaDataJAXRPC)handlerMetaData;
            handlerRoles.addAll(jaxrpcMetaData.getSoapRoles());
            HashMap<String, String> hConfig = new HashMap<String, String>();
            for (UnifiedInitParamMetaData param : jaxrpcMetaData.getInitParams()) {
                hConfig.put(param.getParamName(), param.getParamValue());
            }
            Set<QName> headers = jaxrpcMetaData.getSoapHeaders();
            QName[] headerArr = new QName[headers.size()];
            headers.toArray(headerArr);
            Class hClass = jaxrpcMetaData.getHandlerClass();
            hConfig.put(UnifiedHandlerMetaData.HandlerType.class.getName(), (String)jaxrpcMetaData.getHandlerType());
            HandlerInfo info = new HandlerInfo(hClass, hConfig, headerArr);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding server side handler to service '" + sepMetaData.getPortName() + "': " + info));
            }
            hInfos.add(info);
        }
        this.initHandlerChain(sepMetaData, hInfos, handlerRoles, type);
    }

    private void initHandlerChain(ServerEndpointMetaData sepMetaData, List<HandlerInfo> hInfos, Set<String> handlerRoles, UnifiedHandlerMetaData.HandlerType type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Init handler chain with [" + hInfos.size() + "] handlers"));
        }
        ServerHandlerChain handlerChain = new ServerHandlerChain(hInfos, handlerRoles, type);
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            this.preHandlerChain = handlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            this.jaxrpcHandlerChain = handlerChain;
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            this.postHandlerChain = handlerChain;
        }
        if (handlerChain.getState() == 1) {
            handlerChain.init(null);
        }
        handlerChain.pullHeaders(this.headers);
        Collections.addAll(this.roles, handlerChain.getRoles());
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    @Override
    public Set<QName> getHeaders() {
        return this.headers;
    }
}

