/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.ResourceBundle;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.XMLContent;
import org.jboss.ws.core.soap.utils.XMLFragment;
import org.w3c.dom.Node;

public class DOMContent
extends SOAPContent {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DOMContent.class);
    private static Logger log = Logger.getLogger(DOMContent.class);

    protected DOMContent(SOAPContentElement container) {
        super(container);
    }

    @Override
    SOAPContent.State getState() {
        return SOAPContent.State.DOM_VALID;
    }

    @Override
    SOAPContent transitionTo(SOAPContent.State nextState) {
        SOAPContent next = null;
        if (SOAPContent.State.XML_VALID == nextState) {
            log.debug((Object)"getXMLFragment from DOM");
            DOMSource domSource = new DOMSource((Node)((Object)this.container));
            XMLFragment fragment = new XMLFragment(domSource);
            if (log.isDebugEnabled()) {
                log.debug((Object)("xmlFragment: " + fragment));
            }
            XMLContent xmlValid = new XMLContent(this.container);
            xmlValid.setXMLFragment(fragment);
            next = xmlValid;
        } else if (SOAPContent.State.OBJECT_VALID == nextState) {
            XMLFragment fragment = new XMLFragment(new DOMSource((Node)((Object)this.container)));
            XMLContent tmpState = new XMLContent(this.container);
            tmpState.setXMLFragment(fragment);
            next = tmpState.transitionTo(SOAPContent.State.OBJECT_VALID);
        } else if (SOAPContent.State.DOM_VALID == nextState) {
            next = this;
        } else {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ILLEGAL_STATE_REQUESTED", (Object[])new Object[]{nextState}));
        }
        return next;
    }

    @Override
    public XMLFragment getXMLFragment() {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"XMLFRAGMENT_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    @Override
    public void setXMLFragment(XMLFragment xmlFragment) {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"XMLFRAGMENT_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    @Override
    public Object getObjectValue() {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OBJECT_VALUE_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    @Override
    public void setObjectValue(Object objValue) {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OBJECT_VALUE_NOT_AVAILABLE", (Object[])new Object[0]));
    }
}

