/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.ResourceBundle;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.client.HTTPRemotingConnection;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.SOAPProtocolConnectionHTTP;
import org.jboss.ws.core.soap.SOAPMessageImpl;

public class SOAPConnectionImpl
extends SOAPConnection {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SOAPConnectionImpl.class);
    private RemoteConnection remotingConnection = new SOAPProtocolConnectionHTTP();

    public SOAPMessage call(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        if (reqMessage == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOAPMESSAGE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        return this.callInternal(reqMessage, endpoint, false);
    }

    public SOAPMessage get(Object endpoint) throws SOAPException {
        return this.callInternal(null, endpoint, false);
    }

    public SOAPMessage callOneWay(SOAPMessage reqMessage, Object endpoint) throws SOAPException {
        if (reqMessage == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOAPMESSAGE_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        return this.callInternal(reqMessage, endpoint, true);
    }

    private RemoteConnection getRemotingConnection(Object endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        return this.remotingConnection;
    }

    public void close() throws SOAPException {
        if (this.remotingConnection != null && this.remotingConnection instanceof HTTPRemotingConnection) {
            HTTPRemotingConnection conn = (HTTPRemotingConnection)this.remotingConnection;
            if (conn.isClosed()) {
                throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOAPCONNECTION_IS_ALREADY_CLOSED", (Object[])new Object[0]));
            }
            conn.setClosed(true);
        }
    }

    private SOAPMessage callInternal(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws SOAPException {
        try {
            this.remotingConnection = this.getRemotingConnection(endpoint);
            SOAPMessage resMessage = this.remotingConnection.invoke((SOAPMessageImpl)reqMessage, endpoint, oneway);
            return resMessage;
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SOAPException) {
                throw (SOAPException)cause;
            }
            throw new SOAPException((Throwable)ex);
        }
    }
}

