/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.EnvelopeBuilderDOM;
import org.jboss.ws.core.soap.NodeImpl;
import org.jboss.ws.core.soap.NodeListImpl;
import org.jboss.ws.core.soap.SOAPDocument;
import org.jboss.ws.core.soap.utils.Style;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPPartImpl
extends SOAPPart {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SOAPPartImpl.class);
    private static Logger log = Logger.getLogger(SOAPPartImpl.class);
    private SOAPMessage soapMessage;
    private SOAPEnvelope soapEnvelope;
    private SOAPDocument doc = new SOAPDocument();

    SOAPPartImpl(SOAPMessage message) {
        this.soapMessage = message;
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        return this.soapEnvelope;
    }

    public void setEnvelope(SOAPEnvelope soapEnvelope) {
        this.soapEnvelope = soapEnvelope;
    }

    public void removeMimeHeader(String s) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.removeHeader(s);
    }

    public void removeAllMimeHeaders() {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.removeAllHeaders();
    }

    public String[] getMimeHeader(String name) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getHeader(name);
    }

    public void setMimeHeader(String name, String value) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.setHeader(name, value);
    }

    public void addMimeHeader(String name, String value) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        mimeHeaders.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getMatchingHeaders(names);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
        return mimeHeaders.getNonMatchingHeaders(names);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting content source to null removes the SOAPEnvelope");
            }
            this.soapEnvelope = null;
            return;
        }
        if (source instanceof DOMSource) {
            Element domElement;
            DOMSource domSource = (DOMSource)source;
            Node node = domSource.getNode();
            if (node instanceof Document) {
                domElement = ((Document)node).getDocumentElement();
            } else {
                if (!(node instanceof Element)) throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_DOMSOURCE_NODE", (Object[])new Object[]{node}));
                domElement = (Element)node;
            }
            EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService((String)EnvelopeBuilder.class.getName(), (String)EnvelopeBuilderDOM.class.getName());
            envBuilder.setStyle(Style.DOCUMENT);
            envBuilder.build(this.soapMessage, domElement);
            return;
        }
        if (!(source instanceof StreamSource)) throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_SOURCE_PARAMETER", (Object[])new Object[]{source}));
        try {
            StreamSource streamSource = (StreamSource)source;
            EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService((String)EnvelopeBuilder.class.getName(), (String)EnvelopeBuilderDOM.class.getName());
            envBuilder.setStyle(Style.DOCUMENT);
            InputStream stream = streamSource.getInputStream();
            Reader reader = streamSource.getReader();
            if (stream != null) {
                envBuilder.build(this.soapMessage, stream, false);
                return;
            } else {
                if (reader == null) return;
                envBuilder.build(this.soapMessage, reader, false);
            }
            return;
        }
        catch (IOException e) {
            throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PARSE_STREAM_SOURCE", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public Source getContent() throws SOAPException {
        return new DOMSource((Node)this.soapEnvelope);
    }

    public DOMImplementation getImplementation() {
        return this.doc.getImplementation();
    }

    public DocumentFragment createDocumentFragment() {
        return this.doc.createDocumentFragment();
    }

    public DocumentType getDoctype() {
        return this.doc.getDoctype();
    }

    public Element getDocumentElement() {
        return this.soapEnvelope;
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.doc.createAttribute(name);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.doc.createCDATASection(data);
    }

    public Comment createComment(String data) {
        return this.doc.createComment(data);
    }

    public Element createElement(String tagName) throws DOMException {
        return this.doc.createElement(tagName);
    }

    public Element getElementById(String elementId) {
        return this.doc.getElementById(elementId);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.doc.createEntityReference(name);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.doc.importNode(importedNode, deep);
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.doc.getElementsByTagName(tagname);
    }

    public Text createTextNode(String data) {
        return this.doc.createTextNode(data);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.doc.createAttributeNS(namespaceURI, qualifiedName);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.doc.createElementNS(namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.doc.getElementsByTagNameNS(namespaceURI, localName);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.doc.createProcessingInstruction(target, data);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.doc.appendChild(newChild);
    }

    public Node cloneNode(boolean deep) {
        return this.doc.cloneNode(deep);
    }

    public NamedNodeMap getAttributes() {
        return this.doc.getAttributes();
    }

    public NodeList getChildNodes() {
        ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
        if (this.soapEnvelope != null) {
            list.add((NodeImpl)this.soapEnvelope);
        }
        return new NodeListImpl(list);
    }

    public Node getFirstChild() {
        return this.soapEnvelope;
    }

    public Node getLastChild() {
        return this.soapEnvelope;
    }

    public String getLocalName() {
        return this.doc.getLocalName();
    }

    public String getNamespaceURI() {
        return this.doc.getNamespaceURI();
    }

    public Node getNextSibling() {
        return this.doc.getNextSibling();
    }

    public String getNodeName() {
        return this.doc.getNodeName();
    }

    public short getNodeType() {
        return this.doc.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.doc.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node getParentNode() {
        return this.doc.getParentNode();
    }

    public String getPrefix() {
        return this.doc.getPrefix();
    }

    public Node getPreviousSibling() {
        return this.doc.getPreviousSibling();
    }

    public boolean hasAttributes() {
        return this.doc.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.doc.hasChildNodes();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.doc.insertBefore(newChild, refChild);
    }

    public boolean isSupported(String feature, String version) {
        return this.doc.isSupported(feature, version);
    }

    public void normalize() {
        this.doc.normalize();
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.doc.removeChild(oldChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.doc.replaceChild(newChild, oldChild);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.doc.setNodeValue(nodeValue);
    }

    public void setPrefix(String s) throws DOMException {
        this.doc.setPrefix(s);
    }

    public Node adoptNode(Node source) throws DOMException {
        return this.doc.adoptNode(source);
    }

    public String getDocumentURI() {
        return this.doc.getDocumentURI();
    }

    public DOMConfiguration getDomConfig() {
        return this.doc.getDomConfig();
    }

    public String getInputEncoding() {
        return this.doc.getInputEncoding();
    }

    public boolean getStrictErrorChecking() {
        return this.doc.getStrictErrorChecking();
    }

    public String getXmlEncoding() {
        return this.doc.getXmlEncoding();
    }

    public boolean getXmlStandalone() {
        return this.doc.getXmlStandalone();
    }

    public String getXmlVersion() {
        return this.doc.getXmlVersion();
    }

    public void normalizeDocument() {
        this.doc.normalizeDocument();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return this.doc.renameNode(n, namespaceURI, qualifiedName);
    }

    public void setDocumentURI(String documentURI) {
        this.doc.setDocumentURI(documentURI);
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.doc.setStrictErrorChecking(strictErrorChecking);
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.doc.setXmlStandalone(xmlStandalone);
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.doc.setXmlVersion(xmlVersion);
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return this.doc.compareDocumentPosition(other);
    }

    public String getBaseURI() {
        return this.doc.getBaseURI();
    }

    public Object getFeature(String feature, String version) {
        return this.doc.getFeature(feature, version);
    }

    public String getTextContent() throws DOMException {
        return this.doc.getTextContent();
    }

    public Object getUserData(String key) {
        return this.doc.getUserData(key);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.doc.isDefaultNamespace(namespaceURI);
    }

    public boolean isEqualNode(Node arg) {
        return this.doc.isEqualNode(arg);
    }

    public boolean isSameNode(Node other) {
        return this.doc.isSameNode(other);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.doc.lookupNamespaceURI(prefix);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.doc.lookupPrefix(namespaceURI);
    }

    public void setTextContent(String textContent) throws DOMException {
        this.doc.setTextContent(textContent);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.doc.setUserData(key, data, handler);
    }

    public void detachNode() {
    }

    public SOAPElement getParentElement() {
        return null;
    }

    public String getValue() {
        return null;
    }

    public void recycleNode() {
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"THE_PARENT_ELEMENT_NOT_DEFINED", (Object[])new Object[0]));
    }

    public void setValue(String value) {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SETTING_VALUE_NOT_DEFINED", (Object[])new Object[0]));
    }
}

