/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.AbstractDeserializerFactory;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.soap.DOMContent;
import org.jboss.ws.core.soap.ObjectContent;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.core.soap.utils.XMLFragment;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XMLContent
extends SOAPContent {
    private static final ResourceBundle bundle = BundleUtils.getBundle(XMLContent.class);
    private static final Logger log = Logger.getLogger(XMLContent.class);
    private XMLFragment xmlFragment;
    private Document document = DOMUtils.getOwnerDocument();

    protected XMLContent(SOAPContentElement container) {
        super(container);
    }

    @Override
    SOAPContent.State getState() {
        return SOAPContent.State.XML_VALID;
    }

    @Override
    SOAPContent transitionTo(SOAPContent.State nextState) {
        SOAPContent next;
        if (nextState == SOAPContent.State.XML_VALID) {
            next = this;
        } else if (nextState == SOAPContent.State.OBJECT_VALID) {
            Object obj = this.unmarshallObjectContents();
            ObjectContent objectValid = new ObjectContent(this.container);
            objectValid.setObjectValue(obj);
            next = objectValid;
        } else if (nextState == SOAPContent.State.DOM_VALID) {
            try {
                this.expandContainerChildren();
            }
            catch (SOAPException ex) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_EXPAND_CONTAINER_CHILDREN", (Object[])new Object[0]), ex);
            }
            next = new DOMContent(this.container);
        } else {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ILLEGAL_STATE_REQUESTED", (Object[])new Object[]{nextState}));
        }
        return next;
    }

    @Override
    public XMLFragment getXMLFragment() {
        return this.xmlFragment;
    }

    @Override
    public void setXMLFragment(XMLFragment xmlFragment) {
        this.xmlFragment = xmlFragment;
    }

    @Override
    public Object getObjectValue() {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OBJECT_VALUE_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    @Override
    public void setObjectValue(Object objValue) {
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OBJECT_VALUE_NOT_AVAILABLE", (Object[])new Object[0]));
    }

    private Object unmarshallObjectContents() {
        Object obj;
        boolean debugEnabled;
        block12: {
            CommonMessageContext msgContext;
            QName xmlType = this.container.getXmlType();
            Class javaType = this.container.getJavaType();
            debugEnabled = log.isDebugEnabled();
            if (debugEnabled) {
                log.debug((Object)("getObjectValue [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
            }
            if ((msgContext = MessageContextAssociation.peekMessageContext()) == null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MESSAGECONTEXT_NOT_AVAILABLE", (Object[])new Object[0]));
            }
            SerializationContext serContext = msgContext.getSerializationContext();
            ParameterMetaData pmd = this.container.getParamMetaData();
            OperationMetaData opMetaData = pmd.getOperationMetaData();
            serContext.setProperty(ParameterMetaData.class.getName(), pmd);
            serContext.setJavaType(javaType);
            try {
                TypeMappingImpl typeMapping = serContext.getTypeMapping();
                AbstractDeserializerFactory deserializerFactory = XMLContent.getDeserializerFactory(typeMapping, javaType, xmlType);
                DeserializerSupport des = deserializerFactory.getDeserializer();
                obj = des.deserialize(this.container, serContext);
                if (obj == null) break block12;
                Class<?> objType = obj.getClass();
                boolean isAssignable = JavaUtils.isAssignableFrom((Class)javaType, objType);
                if (!isAssignable && javaType.isArray()) {
                    try {
                        Method toArrayMethod = objType.getMethod("toArray", new Class[0]);
                        Class<?> returnType = toArrayMethod.getReturnType();
                        if (JavaUtils.isAssignableFrom((Class)javaType, returnType)) {
                            Method getValueMethod = objType.getMethod("getValue", new Class[0]);
                            Object value = getValueMethod.invoke(obj, new Object[0]);
                            if (value != null) {
                                obj = toArrayMethod.invoke(obj, new Object[0]);
                            } else {
                                Class<?> componentType = javaType.getComponentType();
                                obj = Array.newInstance(componentType, 0);
                            }
                            isAssignable = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!isAssignable && !JavaUtils.isAssignableFrom((Class)javaType, obj.getClass())) {
                    throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"JAVA_TYPE_NOT_ASSIGNABLE", (Object[])new Object[]{javaType, objType.getName()}));
                }
            }
            catch (BindingException e) {
                throw new WSException(e);
            }
        }
        if (debugEnabled) {
            log.debug((Object)("objectValue: " + (obj != null ? obj.getClass().getName() : null)));
        }
        return obj;
    }

    private static AbstractDeserializerFactory getDeserializerFactory(TypeMappingImpl typeMapping, Class javaType, QName xmlType) {
        Class arrayWrapperType;
        AbstractDeserializerFactory deserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(javaType, xmlType);
        if (deserializerFactory == null && javaType.isArray() && (arrayWrapperType = typeMapping.getJavaType(xmlType)) != null) {
            try {
                Method toArrayMethod = arrayWrapperType.getMethod("toArray", new Class[0]);
                Class<?> returnType = toArrayMethod.getReturnType();
                if (JavaUtils.isAssignableFrom((Class)javaType, returnType)) {
                    deserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(arrayWrapperType, xmlType);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (deserializerFactory == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_DESERIALIZER_FACTORY", (Object[])new Object[]{xmlType, javaType}));
        }
        return deserializerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandContainerChildren() throws SOAPException {
        String oldPrefix;
        boolean artificalElement;
        Element domElement = this.xmlFragment.toElement();
        if (domElement == this.container) {
            return;
        }
        QName qname = this.container.getElementQName();
        QName contentRootName = DOMUtils.getElementQName((Element)domElement);
        boolean bl = artificalElement = SOAPContentElement.GENERIC_PARAM_NAME.equals(qname) || SOAPContentElement.GENERIC_RETURN_NAME.equals(qname);
        if (!artificalElement && !contentRootName.equals(qname)) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"DOES_NOT_MATCH_ELEMENT_NAME", (Object[])new Object[]{contentRootName, qname}));
        }
        this.container.removeContents();
        if (artificalElement) {
            this.container.setElementQNameInternal(contentRootName);
        }
        if ((oldPrefix = this.container.getPrefix()) != null) {
            this.container.removeNamespaceDeclaration(oldPrefix);
        }
        DOMUtils.copyAttributes((Element)((Object)this.container), (Element)domElement);
        this.container.setPrefix(domElement.getPrefix());
        SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
        Document ownerDoc = this.container.getOwnerDocument();
        NodeList nlist = domElement.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            String nodeValue;
            Node child = nlist.item(i);
            short childType = child.getNodeType();
            if (childType == 1) {
                boolean setOwnerDocument = DOMUtils.peekOwnerDocument() == null;
                try {
                    if (setOwnerDocument) {
                        DOMUtils.setOwnerDocument((Document)this.document);
                    }
                    SOAPElement soapElement = soapFactory.createElement((Element)child);
                    this.container.addChildElement(soapElement);
                    continue;
                }
                finally {
                    if (setOwnerDocument) {
                        DOMUtils.clearThreadLocals();
                    }
                }
            }
            if (childType == 3) {
                nodeValue = child.getNodeValue();
                this.container.addTextNode(nodeValue);
                continue;
            }
            if (childType == 8) {
                nodeValue = child.getNodeValue();
                Comment comment = ownerDoc.createComment(nodeValue);
                this.container.appendChild(comment);
                continue;
            }
            if (childType == 4) {
                nodeValue = child.getNodeValue();
                this.container.addTextNode(nodeValue);
                continue;
            }
            log.trace((Object)("Ignore child type: " + childType));
        }
    }
}

