/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxrpc;

import java.util.ResourceBundle;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCMetaDataBuilder;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class JAXRPCServerMetaDataBuilder
extends JAXRPCMetaDataBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXRPCServerMetaDataBuilder.class);
    final Logger log = Logger.getLogger(JAXRPCServerMetaDataBuilder.class);

    public UnifiedMetaData buildMetaData(ArchiveDeployment dep) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("START buildMetaData: [name=" + dep.getCanonicalName() + "]"));
        }
        try {
            WebserviceDescriptionMetaData[] wsDescriptionArr;
            UnifiedMetaData wsMetaData = new UnifiedMetaData(dep.getRootFile());
            wsMetaData.setDeploymentName(dep.getCanonicalName());
            ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
            if (null == runtimeClassLoader) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"RUNTIME_LOADER_CANNOT_BE_NULL", (Object[])new Object[0]));
            }
            wsMetaData.setClassLoader(runtimeClassLoader);
            WebservicesMetaData jaxrpcMapping = (WebservicesMetaData)dep.getAttachment(WebservicesMetaData.class);
            for (WebserviceDescriptionMetaData wsdMetaData : wsDescriptionArr = jaxrpcMapping.getWebserviceDescriptions()) {
                PortComponentMetaData[] pcMetaDataArr;
                ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, null);
                serviceMetaData.setWebserviceDescriptionName(wsdMetaData.getWebserviceDescriptionName());
                wsMetaData.addService(serviceMetaData);
                String wsdlFile = wsdMetaData.getWsdlFile();
                serviceMetaData.setWsdlFile(wsdlFile);
                WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
                String mappingFile = wsdMetaData.getJaxrpcMappingFile();
                serviceMetaData.setMappingLocation(dep.getResourceResolver().resolve(mappingFile));
                JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
                if (javaWsdlMapping == null) {
                    throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MAPPING_FILE_NOT_CONFIGURED", (Object[])new Object[0]));
                }
                this.setupTypesMetaData(serviceMetaData);
                for (PortComponentMetaData pcMetaData : pcMetaDataArr = wsdMetaData.getPortComponents()) {
                    WSDLEndpoint wsdlEndpoint;
                    String linkName = pcMetaData.getEjbLink() != null ? pcMetaData.getEjbLink() : pcMetaData.getServletLink();
                    QName portName = pcMetaData.getWsdlPort();
                    if (portName.getNamespaceURI().length() == 0) {
                        String nsURI = wsdlDefinitions.getTargetNamespace();
                        portName = new QName(nsURI, portName.getLocalPart());
                        this.log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ADDING_WSDL_TNS", (Object[])new Object[]{portName}));
                        pcMetaData.setWsdlPort(portName);
                    }
                    if ((wsdlEndpoint = this.getWsdlEndpoint(wsdlDefinitions, portName)) == null) {
                        throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_PORT", (Object[])new Object[]{portName}));
                    }
                    serviceMetaData.setServiceName(wsdlEndpoint.getWsdlService().getName());
                    QName interfaceQName = wsdlEndpoint.getInterface().getName();
                    Endpoint ep = dep.getService().getEndpointByName(linkName);
                    ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, ep, portName, interfaceQName);
                    sepMetaData.setPortComponentName(pcMetaData.getPortComponentName());
                    sepMetaData.setLinkName(linkName);
                    serviceMetaData.addEndpoint(sepMetaData);
                    this.initEndpointEncodingStyle(sepMetaData);
                    this.initEndpointAddress((Deployment)dep, sepMetaData);
                    this.initEndpointBinding(wsdlEndpoint, (EndpointMetaData)sepMetaData);
                    EJBArchiveMetaData apMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
                    JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
                    if (apMetaData != null) {
                        wsMetaData.setSecurityDomain(apMetaData.getSecurityDomain());
                        String wsdName = serviceMetaData.getWebserviceDescriptionName();
                        String wsdlPublishLocation = apMetaData.getWsdlPublishLocationByName(wsdName);
                        serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                        EJBMetaData bmd = apMetaData.getBeanByEjbName(linkName);
                        if (bmd == null) {
                            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_UNIFIEDBEANMETADATA", (Object[])new Object[]{linkName}));
                        }
                        EJBSecurityMetaData smd = bmd.getSecurityMetaData();
                        if (smd != null) {
                            String authMethod = smd.getAuthMethod();
                            sepMetaData.setAuthMethod(authMethod);
                            String transportGuarantee = smd.getTransportGuarantee();
                            sepMetaData.setTransportGuarantee(transportGuarantee);
                            Boolean secureWSDLAccess = smd.getSecureWSDLAccess();
                            sepMetaData.setSecureWSDLAccess(secureWSDLAccess);
                        }
                    } else if (webMetaData != null) {
                        wsMetaData.setSecurityDomain(webMetaData.getSecurityDomain());
                        String targetBean = (String)webMetaData.getServletClassNames().get(linkName);
                        sepMetaData.setServiceEndpointImplName(targetBean);
                        String wsdName = serviceMetaData.getWebserviceDescriptionName();
                        String wsdlPublishLocation = webMetaData.getWsdlPublishLocationByName(wsdName);
                        serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                        this.initTransportGuaranteeJSE((Deployment)dep, sepMetaData, linkName);
                    }
                    ObjectName sepID = JAXRPCServerMetaDataBuilder.createServiceEndpointID((Deployment)dep, sepMetaData);
                    sepMetaData.setServiceEndpointID(sepID);
                    JAXRPCServerMetaDataBuilder.replaceAddressLocation(sepMetaData);
                    String seiName = pcMetaData.getServiceEndpointInterface();
                    sepMetaData.setServiceEndpointInterfaceName(seiName);
                    ServiceEndpointInterfaceMapping seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMapping(seiName);
                    if (seiMapping == null) {
                        this.log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_SEI_MAPPING", (Object[])new Object[]{seiName}));
                    }
                    this.setupOperationsFromWSDL(sepMetaData, wsdlEndpoint, seiMapping);
                    for (UnifiedHandlerMetaData uhmd : pcMetaData.getHandlers()) {
                        Set portNames = uhmd.getPortNames();
                        if (portNames.size() != 0 && !portNames.contains(portName.getLocalPart())) continue;
                        HandlerMetaDataJAXRPC hmd = HandlerMetaDataJAXRPC.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                        sepMetaData.addHandler(hmd);
                    }
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            }
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_BUILD_META_DATA", (Object[])new Object[]{ex.getMessage()}), ex);
        }
    }

    private WSDLEndpoint getWsdlEndpoint(WSDLDefinitions wsdlDefinitions, QName portName) {
        WSDLEndpoint wsdlEndpoint = null;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            WSDLEndpoint auxEndpoint = wsdlService.getEndpoint(portName);
            if (auxEndpoint == null) continue;
            wsdlEndpoint = auxEndpoint;
            break;
        }
        return wsdlEndpoint;
    }
}

