/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.ws.common.injection.InjectionHelper;
import org.jboss.ws.common.injection.PreDestroyHolder;
import org.jboss.ws.common.servlet.AbstractEndpointServlet;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.ServletDelegate;
import org.jboss.wsf.spi.management.EndpointResolver;
import org.jboss.wsf.stack.jbws.WebAppResolver;

public final class EndpointServlet
extends AbstractEndpointServlet
implements ServletDelegate {
    private List<PreDestroyHolder> preDestroyRegistry = new LinkedList<PreDestroyHolder>();
    private final Object lock = new Object();

    protected final EndpointResolver newEndpointResolver(String contextPath, String servletName) {
        return new WebAppResolver(contextPath, servletName);
    }

    protected final void postService() {
        this.registerForPreDestroy(this.endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Object object = this.lock;
        synchronized (object) {
            for (PreDestroyHolder holder : this.preDestroyRegistry) {
                try {
                    Object targetBean = holder.getObject();
                    InjectionHelper.callPreDestroyMethod((Object)targetBean);
                }
                catch (Exception exception) {
                    Logger.getLogger(EndpointServlet.class).error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.preDestroyRegistry.clear();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForPreDestroy(Endpoint ep) {
        PreDestroyHolder holder = (PreDestroyHolder)ep.getAttachment(PreDestroyHolder.class);
        if (holder != null) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.preDestroyRegistry.contains(holder)) {
                    this.preDestroyRegistry.add(holder);
                }
            }
            ep.removeAttachment(PreDestroyHolder.class);
        }
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doHead(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doPut(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doDelete(request, response);
    }

    public void service(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.service(request, response);
    }
}

