/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCServerMetaDataBuilder;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class UnifiedMetaDataDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ResourceBundle bundle = BundleUtils.getBundle(UnifiedMetaDataDeploymentAspect.class);

    public void start(Deployment dep) {
        UnifiedMetaData umd = (UnifiedMetaData)dep.getAttachment(UnifiedMetaData.class);
        if (umd == null) {
            JAXRPCServerMetaDataBuilder builder;
            if (WSHelper.isJaxrpcJseDeployment((Deployment)dep) && !WSHelper.isJaxwsDeployment((Deployment)dep)) {
                builder = new JAXRPCServerMetaDataBuilder();
                umd = builder.buildMetaData((ArchiveDeployment)dep);
            } else if (WSHelper.isJaxrpcEjbDeployment((Deployment)dep) && !WSHelper.isJaxwsDeployment((Deployment)dep)) {
                builder = new JAXRPCServerMetaDataBuilder();
                umd = builder.buildMetaData((ArchiveDeployment)dep);
            }
            dep.addAttachment(UnifiedMetaData.class, (Object)umd);
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
            if (sepMetaData != null) continue;
            sepMetaData = this.getEndpointMetaData(umd, ep);
            sepMetaData.setEndpoint(ep);
            ep.addAttachment(ServerEndpointMetaData.class, (Object)sepMetaData);
            String targetBean = ep.getTargetBeanName();
            if (targetBean == null) continue;
            sepMetaData.setServiceEndpointImplName(targetBean);
        }
    }

    private ServerEndpointMetaData getEndpointMetaData(UnifiedMetaData umd, Endpoint ep) {
        String epName = ep.getShortName();
        ServerEndpointMetaData epMetaData = null;
        block0: for (ServiceMetaData serviceMetaData : umd.getServices()) {
            for (EndpointMetaData aux : serviceMetaData.getEndpoints()) {
                String linkName = ((ServerEndpointMetaData)aux).getLinkName();
                if (!epName.equals(linkName)) continue;
                epMetaData = (ServerEndpointMetaData)aux;
                continue block0;
            }
        }
        if (epMetaData == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_ENDPOINTMD", (Object[])new Object[]{epName}));
        }
        return epMetaData;
    }
}

