/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.DirectionHolder;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.HeaderSource;
import org.jboss.ws.core.SecurityActions;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.RemoteConnectionFactory;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.core.soap.utils.Style;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public abstract class CommonClient
implements StubExt,
HeaderSource {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CommonClient.class);
    private static Logger log = Logger.getLogger(CommonClient.class);
    public static final String SESSION_COOKIES = "org.jboss.ws.maintain.session.cookies";
    protected EndpointMetaData epMetaData;
    protected QName operationName;
    protected CommonBindingProvider bindingProvider;
    private List<AttachmentPart> attachmentParts = new ArrayList<AttachmentPart>();

    protected CommonClient(ServiceMetaData serviceMetaData) {
        if (serviceMetaData != null && serviceMetaData.getEndpoints().size() == 1) {
            this.epMetaData = serviceMetaData.getEndpoints().get(0);
        }
        this.bindingProvider = this.getCommonBindingProvider();
    }

    protected CommonClient(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
        this.bindingProvider = this.getCommonBindingProvider();
    }

    protected CommonClient(ServiceMetaData serviceMetaData, QName portName, QName opName) {
        if (serviceMetaData != null) {
            EndpointMetaData epMetaData = null;
            if (serviceMetaData.getEndpoints().size() > 0 && (epMetaData = serviceMetaData.getEndpoint(portName)) == null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_ENDPOINT_FOR_NAME", (Object[])new Object[]{portName}));
            }
            if (epMetaData != null) {
                this.epMetaData = epMetaData;
            }
        }
        if (opName != null) {
            this.setOperationName(opName);
        }
        this.bindingProvider = this.getCommonBindingProvider();
    }

    public abstract String getTargetEndpointAddress();

    public abstract void setTargetEndpointAddress(String var1);

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public OperationMetaData getOperationMetaData() {
        if (this.operationName == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OPERATION_NAME_NOT_SET", (Object[])new Object[0]));
        }
        return this.getOperationMetaData(this.operationName);
    }

    public OperationMetaData getOperationMetaData(QName opName) {
        if (opName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_OPERATIONMETADATA", (Object[])new Object[0]));
        }
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        OperationMetaData opMetaData = epMetaData.getOperation(opName);
        if (opMetaData == null && epMetaData.getServiceMetaData().getWsdlDefinitions() == null) {
            opMetaData = new OperationMetaData(epMetaData, opName, opName.getLocalPart());
            epMetaData.addOperation(opMetaData);
        }
        if (opMetaData == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_OPERATION_META_DATA_FOR", (Object[])new Object[]{opName}));
        }
        return opMetaData;
    }

    @Override
    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null) {
            ClassLoader ctxLoader = SecurityActions.getContextClassLoader();
            ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter();
            UnifiedMetaData wsMetaData = new UnifiedMetaData((UnifiedVirtualFile)vfsRoot);
            wsMetaData.setClassLoader(ctxLoader);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            wsMetaData.addService(serviceMetaData);
            QName anonQName = new QName("http://www.jboss.org/jbossws", "Anonymous");
            QName anonPort = new QName("http://www.jboss.org/jbossws", "AnonymousPort");
            this.epMetaData = new ClientEndpointMetaData(serviceMetaData, anonPort, anonQName);
            this.epMetaData.setStyle(Style.RPC);
            serviceMetaData.addEndpoint(this.epMetaData);
        }
        return this.epMetaData;
    }

    protected abstract boolean callRequestHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2);

    protected abstract boolean callResponseHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2);

    protected abstract boolean callFaultHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2, Exception var3);

    protected abstract void closeHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2);

    protected abstract void setInboundContextProperties();

    protected abstract void setOutboundContextProperties();

    protected abstract boolean shouldMaintainSession();

    protected EndpointInvocation createEndpointInvocation(OperationMetaData opMetaData) {
        return new EndpointInvocation(opMetaData);
    }

    protected Object invoke(QName opName, Object[] inputParams, boolean forceOneway) throws Exception {
        if (!opName.equals(this.operationName)) {
            this.setOperationName(opName);
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        boolean oneway = forceOneway || opMetaData.isOneWay();
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        msgContext.setEndpointMetaData(this.getEndpointMetaData());
        msgContext.setOperationMetaData(opMetaData);
        Map<String, Object> requestCtx = this.getRequestContext();
        msgContext.putAll((Map<? extends String, ? extends Object>)requestCtx);
        DirectionHolder direction = new DirectionHolder(DirectionHolder.Direction.OutBound);
        UnifiedHandlerMetaData.HandlerType[] handlerType = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
        UnifiedHandlerMetaData.HandlerType[] faultType = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
        QName portName = this.epMetaData.getPortName();
        try {
            CommonBinding binding = this.getCommonBindingProvider().getCommonBinding();
            binding.setHeaderSource(this);
            EndpointInvocation epInv = this.createEndpointInvocation(opMetaData);
            epInv.initInputParams(inputParams);
            this.setOutboundContextProperties();
            SOAPMessage reqMessage = binding.bindRequestMessage(opMetaData, epInv);
            this.addAttachmentParts(reqMessage);
            boolean handlerPass = this.callRequestHandlerChain(portName, handlerType[0]);
            handlerPass = handlerPass && this.callRequestHandlerChain(portName, handlerType[1]);
            handlerPass = handlerPass && this.callRequestHandlerChain(portName, handlerType[2]);
            reqMessage = msgContext.getSOAPMessage();
            if (handlerPass) {
                String targetAddress = this.getTargetEndpointAddress();
                if (targetAddress == null) {
                    throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TARGET_ENDPOINT_ADDRESS_NOT_SET", (Object[])new Object[0]));
                }
                HashMap<String, Object> callProps = new HashMap<String, Object>(requestCtx);
                EndpointInfo epInfo = new EndpointInfo(this.epMetaData, targetAddress, callProps);
                boolean maintainSession = this.shouldMaintainSession();
                if (maintainSession) {
                    this.addSessionInfo(reqMessage, callProps);
                }
                RemoteConnection remoteConnection = new RemoteConnectionFactory().getRemoteConnection(epInfo);
                SOAPMessage resMessage = remoteConnection.invoke(reqMessage, epInfo, oneway);
                if (maintainSession) {
                    this.saveSessionInfo(callProps, requestCtx);
                }
                msgContext = this.processPivotInternal(msgContext, direction);
                msgContext.put("org.jboss.ws.remoting.metadata", (Object)callProps);
                msgContext.setSOAPMessage(resMessage);
            }
            this.setInboundContextProperties();
            Object retObj = null;
            if (!oneway && handlerPass) {
                SOAPMessage resMessage;
                if (binding instanceof CommonSOAPBinding) {
                    ((CommonSOAPBinding)binding).checkMustUnderstand(opMetaData);
                }
                handlerPass = this.callResponseHandlerChain(portName, handlerType[2]);
                faultType[2] = null;
                if (handlerPass) {
                    resMessage = msgContext.getSOAPMessage();
                    binding.unbindResponseMessage(opMetaData, resMessage, epInv);
                }
                handlerPass = handlerPass && this.callResponseHandlerChain(portName, handlerType[1]);
                faultType[1] = null;
                handlerPass = handlerPass && this.callResponseHandlerChain(portName, handlerType[0]);
                faultType[0] = null;
                if (msgContext.isModified()) {
                    log.debug((Object)"Handler modified body payload, unbind message again");
                    resMessage = msgContext.getSOAPMessage();
                    binding.unbindResponseMessage(opMetaData, resMessage, epInv);
                }
                retObj = this.syncOutputParams(inputParams, epInv);
            }
            Object object = retObj;
            return object;
        }
        catch (Exception ex) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"EXCEPTION_CAUGHT_WHILE_(PREPARING_FOR)_PERFORMING_THE_INVOCATION", (Object[])new Object[0]), (Throwable)ex);
            this.processPivotInternal(msgContext, direction);
            if (faultType[2] != null) {
                this.callFaultHandlerChain(portName, faultType[2], ex);
            }
            if (faultType[1] != null) {
                this.callFaultHandlerChain(portName, faultType[1], ex);
            }
            if (faultType[0] != null) {
                this.callFaultHandlerChain(portName, faultType[0], ex);
            }
            throw ex;
        }
        finally {
            this.closeHandlerChain(portName, handlerType[2]);
            this.closeHandlerChain(portName, handlerType[1]);
            this.closeHandlerChain(portName, handlerType[0]);
        }
    }

    private void saveSessionInfo(Map<String, Object> remotingMetadata, Map<String, Object> requestContext) {
        Map headers;
        HashMap<String, String> cookies = (HashMap<String, String>)requestContext.get(SESSION_COOKIES);
        if (cookies == null) {
            cookies = new HashMap<String, String>();
            requestContext.put(SESSION_COOKIES, cookies);
        }
        if ((headers = (Map)remotingMetadata.get("org.jboss.ws.core.client.transport.NettyClient#ResponseHeaders")) != null) {
            List setCookies2;
            ArrayList setCookies = new ArrayList();
            List setCookies1 = (List)headers.get("Set-Cookie");
            if (setCookies1 != null) {
                setCookies.addAll(setCookies1);
            }
            if ((setCookies2 = (List)headers.get("Set-Cookie2")) != null) {
                setCookies.addAll(setCookies2);
            }
            for (String setCookie : setCookies) {
                String pair;
                int index = setCookie.indexOf(59);
                if (index == -1 || (index = (pair = setCookie.substring(0, index)).indexOf(61)) == -1) continue;
                String name = pair.substring(0, index);
                String value = pair.substring(index + 1);
                cookies.put(name, value);
            }
        }
    }

    protected void addSessionInfo(SOAPMessage reqMessage, Map<String, Object> callProperties) {
        Map cookies = (Map)callProperties.get(SESSION_COOKIES);
        if (cookies != null) {
            for (Map.Entry cookie : cookies.entrySet()) {
                reqMessage.getMimeHeaders().addHeader("Cookie", (String)cookie.getKey() + "=" + (String)cookie.getValue());
            }
        }
    }

    private CommonMessageContext processPivotInternal(CommonMessageContext msgContext, DirectionHolder direction) {
        if (direction.getDirection() == DirectionHolder.Direction.OutBound) {
            msgContext = this.processPivot(msgContext);
            direction.setDirection(DirectionHolder.Direction.InBound);
        }
        return msgContext;
    }

    protected void addAttachmentParts(SOAPMessage reqMessage) {
        boolean debugEnabled = log.isDebugEnabled();
        for (AttachmentPart part : this.attachmentParts) {
            if (debugEnabled) {
                log.debug((Object)("Adding attachment part: " + part.getContentId()));
            }
            reqMessage.addAttachmentPart(part);
        }
    }

    protected abstract CommonMessageContext processPivot(CommonMessageContext var1);

    protected abstract CommonBindingProvider getCommonBindingProvider();

    protected abstract Map<String, Object> getRequestContext();

    private Object syncOutputParams(Object[] inParams, EndpointInvocation epInv) throws SOAPException {
        Object retValue = null;
        OperationMetaData opMetaData = this.getOperationMetaData();
        ParameterMetaData retMetaData = opMetaData.getReturnParameter();
        if (retMetaData != null) {
            retValue = epInv.getReturnValue();
            if (opMetaData.isDocumentWrapped() && !retMetaData.isMessageType()) {
                retValue = ParameterWrapping.unwrapResponseParameters(retMetaData, retValue, inParams);
            }
        }
        for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
            ParameterMode paramMode = paramMetaData.getMode();
            int index = paramMetaData.getIndex();
            if (index != -1 && paramMode != ParameterMode.INOUT && paramMode != ParameterMode.OUT) continue;
            QName xmlName = paramMetaData.getXmlName();
            Object value = epInv.getResponseParamValue(xmlName);
            if (index == -1) {
                retValue = value;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("holder [" + index + "] " + xmlName));
            }
            HolderUtils.setHolderValue(inParams[index], value);
        }
        return retValue;
    }

    @Override
    public void addAttachmentPart(AttachmentPart part) {
        this.attachmentParts.add(part);
    }

    @Override
    public void clearAttachmentParts() {
        this.attachmentParts.clear();
    }

    @Override
    public AttachmentPart createAttachmentPart() {
        try {
            MessageFactory factory = MessageFactory.newInstance();
            return factory.createMessage().createAttachmentPart();
        }
        catch (SOAPException ex) {
            throw new JAXRPCException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CREATE_ATTACHMENT_PART", (Object[])new Object[0]));
        }
    }
}

