/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.xb.binding.NamespaceRegistry;

public abstract class CommonMessageContext
implements Map<String, Object> {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CommonMessageContext.class);
    private static Logger log = Logger.getLogger(CommonMessageContext.class);
    public static final String REMOTING_METADATA = "org.jboss.ws.remoting.metadata";
    private SerializationContext serContext;
    private EndpointMetaData epMetaData;
    private OperationMetaData opMetaData;
    private SOAPMessage message;
    protected Map<String, Object> props = new HashMap<String, Object>();
    private boolean isModified;

    public CommonMessageContext() {
    }

    public CommonMessageContext(CommonMessageContext msgContext) {
        this.epMetaData = msgContext.epMetaData;
        this.opMetaData = msgContext.opMetaData;
        this.message = msgContext.message;
        this.serContext = msgContext.serContext;
        this.props = new HashMap<String, Object>(msgContext.props);
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null && this.opMetaData != null) {
            this.epMetaData = this.opMetaData.getEndpointMetaData();
        }
        return this.epMetaData;
    }

    public void setEndpointMetaData(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public void setOperationMetaData(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public SOAPMessage getSOAPMessage() {
        if (this.message != null && !(this.message instanceof SOAPMessage)) {
            throw new UnsupportedOperationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NO_SOAPMESSAGE_AVILABLE", (Object[])new Object[]{this.message.getClass()}));
        }
        return this.message;
    }

    public void setSOAPMessage(SOAPMessage soapMessage) {
        this.message = soapMessage;
        this.setModified(true);
    }

    public SerializationContext getSerializationContext() {
        if (this.serContext == null) {
            this.serContext = this.createSerializationContext();
        }
        return this.serContext;
    }

    public abstract SerializationContext createSerializationContext();

    public void setSerializationContext(SerializationContext serContext) {
        this.serContext = serContext;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.getSerializationContext().getNamespaceRegistry();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean modified) {
        this.isModified = modified;
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.props.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.props.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.props.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.props.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.props.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> srcMap) {
        for (String string : srcMap.keySet()) {
            try {
                Object value = srcMap.get(string);
                this.put(string, value);
            }
            catch (IllegalArgumentException ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Ignore: " + ex.getMessage()));
            }
        }
    }

    @Override
    public void clear() {
        this.props.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.props.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.props.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.props.entrySet();
    }

    public static void cleanupAttachments(CommonMessageContext messageContext) {
        SOAPMessage msg = messageContext.getSOAPMessage();
        if (msg != null && msg instanceof SOAPMessage) {
            Iterator it = msg.getAttachments();
            while (it.hasNext()) {
                AttachmentPart attachment = (AttachmentPart)it.next();
                try {
                    if (!(attachment.getDataHandler().getDataSource() instanceof SwapableMemoryDataSource)) continue;
                    SwapableMemoryDataSource swapFile = (SwapableMemoryDataSource)attachment.getDataHandler().getDataSource();
                    swapFile.cleanup();
                }
                catch (SOAPException e) {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CLEANUP_ATTACHMENT_PART", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
    }
}

