/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;

public class RemoteConnectionFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(RemoteConnectionFactory.class);

    public RemoteConnection getRemoteConnection(EndpointInfo epInfo) {
        String targetAddress = epInfo.getTargetAddress();
        if (targetAddress == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_TARGET_ADDRESS", (Object[])new Object[]{epInfo}));
        }
        String key = null;
        if ((targetAddress = targetAddress.toLowerCase()).startsWith("http")) {
            key = RemoteConnection.class.getName() + ".http";
        }
        if (key == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_REMOTE_CONNETION", (Object[])new Object[]{targetAddress}));
        }
        RemoteConnection con = (RemoteConnection)ServiceLoader.loadService(key, null, (ClassLoader)this.getClass().getClassLoader());
        if (con == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_REMOTE_CONNETION", (Object[])new Object[]{key}));
        }
        return con;
    }
}

