/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding.jbossxb;

import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.SchemaBindingBuilder;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.util.Dom2Sax;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JBossXBSupport {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JBossXBSupport.class);

    public static SchemaBinding getOrCreateSchemaBinding(Map properties) {
        SchemaBinding schemaBinding = null;
        SchemaBindingBuilder bindingBuilder = new SchemaBindingBuilder();
        QName xmlName = (QName)properties.get("org.jboss.xb.root.qname");
        QName xmlType = (QName)properties.get("org.jboss.xb.type.qname");
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            OperationMetaData opMetaData = msgContext.getOperationMetaData();
            EndpointMetaData epMetaData = opMetaData.getEndpointMetaData();
            ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
            schemaBinding = serviceMetaData.getSchemaBinding();
        }
        if (schemaBinding == null) {
            JBossXSModel xsModel = (JBossXSModel)properties.get("org.jboss.xb.xsd.xsmodel");
            JavaWsdlMapping wsdlMapping = (JavaWsdlMapping)properties.get("org.jboss.xb.java.mapping");
            schemaBinding = bindingBuilder.buildSchemaBinding(xsModel, wsdlMapping);
        }
        bindingBuilder.bindParameterToElement(schemaBinding, xmlName, xmlType);
        return schemaBinding;
    }

    public static ObjectLocalMarshaller getWildcardMarshaller() {
        return new ObjectLocalMarshaller(){

            public void marshal(MarshallingContext ctx, Object o) {
                if (o == null) {
                    return;
                }
                Element e = (Element)o;
                ContentHandler ch = ctx.getContentHandler();
                try {
                    Dom2Sax.dom2sax((Element)e, (ContentHandler)ch);
                }
                catch (SAXException e1) {
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_MARSHAL_DOM_ELEMENT", (Object[])new Object[]{new QName(e.getNamespaceURI(), e.getLocalName()), e1.getMessage()}));
                }
            }
        };
    }
}

