/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.JBossXBSerializerFactory;
import org.jboss.ws.core.jaxrpc.binding.SOAPArrayDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.SOAPArraySerializerFactory;
import org.jboss.ws.core.soap.utils.Style;
import org.jboss.ws.core.soap.utils.Use;
import org.jboss.ws.metadata.accessor.AccessorFactory;
import org.jboss.ws.metadata.accessor.AccessorFactoryCreator;
import org.jboss.ws.metadata.umdm.EndpointConfigMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.InitalizableMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;

public abstract class EndpointMetaData
extends ExtensibleMetaData
implements InitalizableMetaData {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointMetaData.class);
    private static Logger log = Logger.getLogger(EndpointMetaData.class);
    public static final Set<String> SUPPORTED_BINDINGS = new HashSet<String>();
    private ServiceMetaData serviceMetaData;
    private EndpointConfigMetaData configMetaData;
    private QName portName;
    private String bindingId;
    private QName portTypeName;
    private String seiName;
    private Class seiClass;
    private String authMethod;
    private Style style;
    private Use use;
    private Boolean wrappedParameterStyle;
    private List<OperationMetaData> operations = new ArrayList<OperationMetaData>();
    private Map<Method, OperationMetaData> opMetaDataCache = new HashMap<Method, OperationMetaData>();
    private List<UnifiedPortComponentRefMetaData> serviceRefContrib = new ArrayList<UnifiedPortComponentRefMetaData>();

    public EndpointMetaData(ServiceMetaData service, QName portName, QName portTypeName) {
        this.serviceMetaData = service;
        this.portName = portName;
        this.portTypeName = portTypeName;
        this.bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName portName) {
        this.portName = portName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public abstract String getEndpointAddress();

    public abstract void setEndpointAddress(String var1);

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingId(String bindingId) {
        if (!SUPPORTED_BINDINGS.contains(bindingId)) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_BINDING", (Object[])new Object[]{bindingId}));
        }
        this.bindingId = bindingId;
    }

    public String getServiceEndpointInterfaceName() {
        return this.seiName;
    }

    public void setServiceEndpointInterfaceName(String seiName) {
        this.seiName = seiName;
        this.seiClass = null;
        UnifiedMetaData wsMetaData = this.serviceMetaData.getUnifiedMetaData();
        if (wsMetaData.isEagerInitialized()) {
            if (!UnifiedMetaData.isFinalRelease()) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"SET_SEI_NAME_AFTER_EAGER_INIT", (Object[])new Object[0]));
            }
            this.initializeInternal();
        }
    }

    public ClassLoader getClassLoader() {
        return this.getServiceMetaData().getUnifiedMetaData().getClassLoader();
    }

    public Class getServiceEndpointInterface() {
        Class<?> tmpClass = this.seiClass;
        if (tmpClass == null && this.seiName != null) {
            try {
                ClassLoader classLoader = this.getClassLoader();
                tmpClass = classLoader.loadClass(this.seiName);
                if (this.serviceMetaData.getUnifiedMetaData().isEagerInitialized()) {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"LOADING_SEI_AFTER_EAGER_INIT", (Object[])new Object[0]));
                    this.seiClass = tmpClass;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_SEI", (Object[])new Object[]{this.seiName}), ex);
            }
        }
        return tmpClass;
    }

    public Use getEncodingStyle() {
        if (this.use == null) {
            this.use = Use.getDefaultUse();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using default encoding style: " + this.use));
            }
        }
        return this.use;
    }

    public void setEncodingStyle(Use value) {
        if (value != null && this.use != null && !this.use.equals(value)) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MIXED_STYLES_NOT_SUPPORTED", (Object[])new Object[0]));
        }
        log.trace((Object)("setEncodingStyle: " + value));
        this.use = value;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = Style.getDefaultStyle();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using default style: " + this.style));
            }
        }
        return this.style;
    }

    public void setStyle(Style value) {
        if (value != null && this.style != null && !this.style.equals(value)) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MIXED_STYLES_NOT_SUPPORTED", (Object[])new Object[0]));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("setStyle: " + value));
        }
        this.style = value;
    }

    public boolean isWrappedParameterStyle() {
        if (this.wrappedParameterStyle == null) {
            this.wrappedParameterStyle = Boolean.TRUE;
        }
        return this.wrappedParameterStyle;
    }

    public void setWrappedParameterStyle(Boolean value) {
        if (value != null && this.wrappedParameterStyle != null && !this.wrappedParameterStyle.equals(value)) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MIXED_SOAP_PARAMETER_STYLES_NOT_SUPPORTED", (Object[])new Object[0]));
        }
        this.wrappedParameterStyle = value;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public List<OperationMetaData> getOperations() {
        return new ArrayList<OperationMetaData>(this.operations);
    }

    public OperationMetaData getOperation(QName xmlName) {
        OperationMetaData opMetaData = null;
        for (OperationMetaData aux : this.operations) {
            QName opQName = aux.getQName();
            String javaName = aux.getJavaName();
            if (!opQName.equals(xmlName) || javaName.endsWith("Async")) continue;
            if (opMetaData == null) {
                opMetaData = aux;
                continue;
            }
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNIQUELY_INDENTIFY_OP", (Object[])new Object[]{xmlName}));
        }
        if (opMetaData == null && this.getStyle() == Style.DOCUMENT) {
            for (OperationMetaData auxOperation : this.operations) {
                ParameterMetaData paramMetaData = null;
                for (ParameterMetaData auxParam : auxOperation.getParameters()) {
                    ParameterMode mode = auxParam.getMode();
                    if (auxParam.isInHeader() || mode == ParameterMode.OUT) continue;
                    paramMetaData = auxParam;
                    break;
                }
                if (paramMetaData == null || !paramMetaData.getXmlName().equals(xmlName)) continue;
                if (opMetaData == null) {
                    opMetaData = auxOperation;
                    continue;
                }
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNIQUELY_INDENTIFY_OP", (Object[])new Object[]{xmlName}));
            }
        }
        return opMetaData;
    }

    public OperationMetaData getOperation(Method method) {
        OperationMetaData opMetaData;
        if (this.opMetaDataCache.size() == 0) {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ACCESS_TO_EMPTY_OP_META_DATA_CACHE", (Object[])new Object[0]));
            this.initializeInternal();
        }
        if ((opMetaData = this.opMetaDataCache.get(method)) == null) {
            for (OperationMetaData aux : this.operations) {
                boolean doesMatch = aux.getJavaMethod().equals(method);
                if (!doesMatch && method.getName().endsWith("Async")) {
                    String name = method.getName();
                    name = name.substring(0, name.length() - 5);
                    doesMatch = aux.getJavaName().equals(name);
                }
                if (!doesMatch) continue;
                this.opMetaDataCache.put(method, aux);
                opMetaData = aux;
                break;
            }
        }
        return opMetaData;
    }

    public void addOperation(OperationMetaData opMetaData) {
        this.operations.add(opMetaData);
    }

    public void clearOperations() {
        this.operations.clear();
    }

    public void addHandlers(List<HandlerMetaData> configHandlers) {
        this.getEndpointConfigMetaData().addHandlers(configHandlers);
    }

    public void addHandler(HandlerMetaData handler) {
        this.getEndpointConfigMetaData().addHandler(handler);
    }

    public void clearHandlers() {
        this.getEndpointConfigMetaData().clearHandlers();
    }

    public List<HandlerMetaData> getHandlerMetaData(UnifiedHandlerMetaData.HandlerType type) {
        return this.getEndpointConfigMetaData().getHandlerMetaData(type);
    }

    public boolean isHandlersInitialized() {
        return this.getEndpointConfigMetaData().isHandlersInitialized();
    }

    public void setHandlersInitialized(boolean flag) {
        this.getEndpointConfigMetaData().setHandlersInitialized(flag);
    }

    public void validate() {
        for (OperationMetaData opMetaData : this.operations) {
            opMetaData.validate();
        }
    }

    @Override
    public void eagerInitialize() {
        this.initializeInternal();
    }

    private void initializeInternal() {
        this.seiClass = null;
        this.getEndpointConfigMetaData().initializeInternal();
        this.eagerInitializeOperations();
        this.eagerInitializeTypes();
        this.eagerInitializeAccessors();
    }

    private void eagerInitializeOperations() {
        this.seiClass = this.getServiceEndpointInterface();
        if (this.seiClass != null) {
            ArrayList<Method> unsynchronizedMethods = new ArrayList<Method>();
            unsynchronizedMethods.addAll(Arrays.asList(this.seiClass.getMethods()));
            for (OperationMetaData opMetaData : this.operations) {
                opMetaData.eagerInitialize(unsynchronizedMethods);
                Method method = opMetaData.getJavaMethod();
                if (method == null) continue;
                this.opMetaDataCache.put(method, opMetaData);
                unsynchronizedMethods.remove(method);
            }
        }
    }

    private void eagerInitializeTypes() {
        TypeMappingImpl typeMapping = this.serviceMetaData.getTypeMapping();
        List<TypeMappingMetaData> typeMappings = this.serviceMetaData.getTypesMetaData().getTypeMappings();
        ArrayList<Class> registeredTypes = new ArrayList<Class>(typeMappings.size());
        for (TypeMappingMetaData tmMetaData : typeMappings) {
            String javaTypeName = tmMetaData.getJavaTypeName();
            QName xmlType = tmMetaData.getXmlType();
            if (xmlType == null) continue;
            List<Class> types = typeMapping.getJavaTypes(xmlType);
            boolean registered = false;
            for (Class current : types) {
                if (!current.getName().equals(javaTypeName)) continue;
                registeredTypes.add(current);
                registered = true;
                break;
            }
            if (registered) continue;
            try {
                ClassLoader classLoader = this.getClassLoader();
                Class javaType = JavaUtils.loadJavaType((String)javaTypeName, (ClassLoader)classLoader);
                if (JavaUtils.isPrimitive((String)javaTypeName)) {
                    javaType = JavaUtils.getWrapperType((Class)javaType);
                }
                registeredTypes.add(javaType);
                if (this.getEncodingStyle() == Use.ENCODED && javaType.isArray()) {
                    typeMapping.register(javaType, xmlType, new SOAPArraySerializerFactory(), new SOAPArrayDeserializerFactory());
                    continue;
                }
                typeMapping.register(javaType, xmlType, new JBossXBSerializerFactory(), new JBossXBDeserializerFactory());
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_CLASS", (Object[])new Object[]{xmlType, javaTypeName}));
            }
        }
    }

    private void eagerInitializeAccessors() {
        ParameterMetaData retParam;
        ArrayList<Class> types = new ArrayList<Class>();
        for (OperationMetaData opMetaData : this.operations) {
            for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                types.add(paramMetaData.getJavaType());
            }
            retParam = opMetaData.getReturnParameter();
            if (retParam == null) continue;
            types.add(retParam.getJavaType());
        }
        for (OperationMetaData opMetaData : this.operations) {
            for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                this.createAccessor(paramMetaData);
            }
            retParam = opMetaData.getReturnParameter();
            if (retParam == null) continue;
            this.createAccessor(retParam);
        }
    }

    private void createAccessor(ParameterMetaData paramMetaData) {
        AccessorFactoryCreator factoryCreator = paramMetaData.getAccessorFactoryCreator();
        if (paramMetaData.getWrappedParameters() != null) {
            AccessorFactory factory = factoryCreator.create(paramMetaData);
            for (WrappedParameter wParam : paramMetaData.getWrappedParameters()) {
                wParam.setAccessor(factory.create(wParam));
            }
        }
    }

    public EndpointConfigMetaData getEndpointConfigMetaData() {
        if (this.configMetaData == null) {
            this.configMetaData = new EndpointConfigMetaData(this);
        }
        return this.configMetaData;
    }

    public List<UnifiedPortComponentRefMetaData> getServiceRefContrib() {
        return this.serviceRefContrib;
    }

    public boolean matches(UnifiedPortComponentRefMetaData pcRef) {
        String seiName = pcRef.getServiceEndpointInterface();
        QName portName = pcRef.getPortQName();
        boolean match = seiName != null && portName != null ? this.getServiceEndpointInterfaceName().equals(seiName) && this.getPortName().equals(portName) : this.getServiceEndpointInterfaceName().equals(seiName) || this.getPortName().equals(portName);
        return match;
    }

    static {
        SUPPORTED_BINDINGS.add("http://schemas.xmlsoap.org/wsdl/soap/http");
        SUPPORTED_BINDINGS.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        SUPPORTED_BINDINGS.add("http://www.w3.org/2004/08/wsdl/http");
    }
}

