/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.JBossWSEntityResolver;
import org.jboss.ws.common.utils.ResourceURL;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.jboss.ws.tools.wsdl.JBossWSDLFactoryImpl;
import org.jboss.ws.tools.wsdl.WSDL11Reader;
import org.jboss.ws.tools.wsdl.WSDL11Writer;
import org.jboss.ws.tools.wsdl.WSDLLocatorImpl;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class WSDLDefinitionsFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSDLDefinitionsFactory.class);
    private static final Logger log = Logger.getLogger(WSDLDefinitionsFactory.class);
    public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
    public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
    private Map features = new HashMap();

    private WSDLDefinitionsFactory() {
    }

    public static WSDLDefinitionsFactory newInstance() {
        return new WSDLDefinitionsFactory();
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        this.features.put(name, value);
    }

    public WSDLDefinitions parse(URL wsdlLocation) throws WSDLException {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"URL_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse: " + wsdlLocation.toExternalForm()));
        }
        JBossWSEntityResolver entityResolver = new JBossWSEntityResolver(ClassLoaderProvider.getDefaultProvider().getServerJAXRPCIntegrationClassLoader());
        WSDLDefinitions wsdlDefinitions = null;
        try {
            WSDLReader wsdlReader;
            Document wsdlDoc = this.getDocument(wsdlLocation);
            String defaultNamespace = this.getDefaultNamespace(wsdlDoc);
            if ("http://schemas.xmlsoap.org/wsdl/".equals(defaultNamespace)) {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance((String)JBossWSDLFactoryImpl.class.getName(), (ClassLoader)this.getClass().getClassLoader());
                wsdlReader = wsdlFactory.newWSDLReader();
                wsdlReader.setFeature(FEATURE_VERBOSE, false);
                for (Map.Entry entry : this.features.entrySet()) {
                    String key = (String)entry.getKey();
                    Boolean flag = (Boolean)entry.getValue();
                    wsdlReader.setFeature(key, flag.booleanValue());
                }
            } else {
                throw new WSDLException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_DEFAULT_NAMESPACE", (Object[])new Object[]{defaultNamespace}));
            }
            Definition definition = wsdlReader.readWSDL((WSDLLocator)new WSDLLocatorImpl((EntityResolver)entityResolver, wsdlLocation));
            wsdlDefinitions = new WSDL11Reader().processDefinition(definition, wsdlLocation);
            wsdlDefinitions.setWsdlDocument(wsdlDoc);
            if (log.isTraceEnabled()) {
                StringWriter stwr = new StringWriter();
                WSDL11Writer wsdlWriter = new WSDL11Writer(wsdlDefinitions);
                wsdlWriter.write(stwr);
                log.trace((Object)("\n" + stwr.toString()));
            }
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSDLException(e);
        }
        return wsdlDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(URL wsdlLocation) throws WSDLException {
        Document document;
        InputStream inputStream = new ResourceURL(wsdlLocation).openStream();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)new JBossWSEntityResolver());
            document = builder.parse(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (ConnectException ex) {
                throw new WSDLException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CONNECT_TO", (Object[])new Object[]{wsdlLocation}));
            }
            catch (Exception ex) {
                throw new WSDLException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PARSE_WSDLLOCATION", (Object[])new Object[]{wsdlLocation}), ex);
            }
        }
        inputStream.close();
        return document;
    }

    private String getDefaultNamespace(Document wsdlDoc) throws WSDLException {
        Element root = wsdlDoc.getDocumentElement();
        String defaultNamespace = root.getNamespaceURI();
        return defaultNamespace;
    }
}

