/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.server.MimeHeaderSource;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.server.ServletHeaderSource;
import org.jboss.ws.core.server.ServletRequestContext;
import org.jboss.ws.core.server.WSDLRequestHandler;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.core.soap.utils.SOAPUtils;
import org.jboss.ws.core.utils.ThreadLocalAssociation;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.stack.jbws.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestHandlerImpl
implements RequestHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(RequestHandlerImpl.class);
    private static final Logger log = Logger.getLogger(RequestHandlerImpl.class);
    protected ServerConfig serverConfig;
    protected MessageFactoryImpl msgFactory;

    public RequestHandlerImpl() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ServerConfig serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        this.init(serverConfig);
    }

    public RequestHandlerImpl(ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVER_CONFIG_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        this.init(serverConfig);
    }

    private void init(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.msgFactory = new MessageFactoryImpl();
    }

    public void handleHttpRequest(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        String method = req.getMethod();
        if (method.equals("POST")) {
            this.doPost(endpoint, req, res, context);
        } else if (method.equals("GET")) {
            this.doGet(endpoint, req, res, context);
        } else {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_METHOD", (Object[])new Object[]{method}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGet(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        if (req.getParameter("wsdl") != null || req.getParameter("WSDL") != null) {
            res.setContentType("text/xml");
            ServletOutputStream out = res.getOutputStream();
            try {
                ServletRequestContext reqContext = new ServletRequestContext(context, req, res);
                this.handleWSDLRequest(endpoint, (OutputStream)out, reqContext);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ioex) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Cannot close output stream", (Throwable)ioex);
                    }
                    log.debug((Object)"Cannot close output stream");
                }
            }
        } else {
            res.setStatus(405);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            ((Writer)out).write("HTTP GET not supported");
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPost: " + req.getRequestURI()));
        }
        ServletInputStream in = req.getInputStream();
        ServletOutputStream out = res.getOutputStream();
        ClassLoader classLoader = endpoint.getService().getDeployment().getRuntimeClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NO_CLASSLOADER_ASSOCIATED", (Object[])new Object[0]));
        }
        ClassLoader ctxClassLoader = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(classLoader);
        try {
            ServletRequestContext reqContext = new ServletRequestContext(context, req, res);
            this.handleRequest(endpoint, (InputStream)in, (OutputStream)out, reqContext);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            SecurityActions.setContextClassLoader(ctxClassLoader);
            try {
                out.close();
            }
            catch (IOException ioex) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Cannot close output stream", (Throwable)ioex);
                }
                log.debug((Object)"Cannot close output stream");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Endpoint endpoint, InputStream inStream, OutputStream outStream, InvocationContext invContext) {
        ServerEndpointMetaData sepMetaData;
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRequest: " + endpoint.getName()));
        }
        if ((sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class)) == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_ENDPOINTMD", (Object[])new Object[0]));
        }
        SOAPMessageContextJAXRPC msgContext = new SOAPMessageContextJAXRPC();
        invContext.addAttachment(MessageContext.class, (Object)msgContext);
        HttpServletResponse httpResponse = null;
        ServletHeaderSource headerSource = null;
        if (invContext instanceof ServletRequestContext) {
            ServletRequestContext reqContext = (ServletRequestContext)invContext;
            ServletContext servletContext = reqContext.getServletContext();
            HttpServletRequest httpRequest = reqContext.getHttpServletRequest();
            httpResponse = reqContext.getHttpServletResponse();
            headerSource = new ServletHeaderSource(httpRequest, httpResponse);
            msgContext.put("javax.xml.ws.servlet.context", (Object)servletContext);
            msgContext.put("javax.xml.ws.servlet.request", (Object)httpRequest);
            msgContext.put("javax.xml.ws.servlet.response", (Object)httpResponse);
        }
        MessageContextAssociation.pushMessageContext(msgContext);
        try {
            msgContext.setEndpointMetaData(sepMetaData);
            SOAPMessage resMessage = this.processRequest(endpoint, headerSource, invContext, inStream);
            SOAPMessageContextJAXRPC reqMsgContext = msgContext;
            boolean isFault = false;
            SOAPPart part = resMessage.getSOAPPart();
            if (part == null) {
                throw new SOAPException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_SOAPPART", (Object[])new Object[0]));
            }
            SOAPEnvelope soapEnv = part.getEnvelope();
            boolean bl = isFault = soapEnv != null && soapEnv.getBody().hasFault();
            if (isFault && httpResponse != null) {
                httpResponse.setStatus(500);
            }
            if (outStream != null) {
                this.sendResponse(endpoint, outStream, isFault);
            }
            CommonMessageContext.cleanupAttachments(reqMsgContext);
        }
        catch (Exception ex) {
            WSException.rethrow(ex);
        }
        finally {
            CommonMessageContext.cleanupAttachments(MessageContextAssociation.peekMessageContext());
            MessageContextAssociation.popMessageContext();
            ThreadLocalAssociation.clear();
        }
    }

    private void sendResponse(Endpoint endpoint, OutputStream output, boolean isFault) throws SOAPException, IOException {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SOAPMessage resMessage = msgContext.getSOAPMessage();
        if (resMessage == null) {
            log.debug((Object)"Null response message");
            return;
        }
        resMessage.writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOAPMessage processRequest(Endpoint ep, MimeHeaderSource headerSource, InvocationContext reqContext, InputStream inputStream) throws BindingException {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
        if (sepMetaData == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_ENDPOINTMD", (Object[])new Object[0]));
        }
        long beginProcessing = 0L;
        boolean debugEnabled = log.isDebugEnabled();
        try {
            EndpointState state = ep.getState();
            if (state != EndpointState.STARTED) {
                QName faultCode = Constants.SOAP11_FAULT_CODE_SERVER;
                String faultString = "Endpoint cannot handle requests in state: " + state;
                throw new CommonSOAPFaultException(faultCode, faultString);
            }
            if (debugEnabled) {
                log.debug((Object)("BEGIN handleRequest: " + ep.getName()));
            }
            beginProcessing = this.initRequestMetrics(ep);
            MimeHeaders headers = headerSource != null ? headerSource.getMimeHeaders() : null;
            this.msgFactory.setStyle(sepMetaData.getStyle());
            SOAPMessage reqMessage = this.msgFactory.createMessage(headers, inputStream);
            msgContext.setSOAPMessage(reqMessage);
            MessageTrace.traceMessage("Incoming Request Message", reqMessage);
            ServiceEndpointInvoker epInvoker = (ServiceEndpointInvoker)ep.getAttachment(ServiceEndpointInvoker.class);
            if (epInvoker == null) {
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_SEINVOKER", (Object[])new Object[0]));
            }
            epInvoker.invoke(reqContext);
            msgContext = MessageContextAssociation.peekMessageContext();
            SOAPMessage resMessage = msgContext.getSOAPMessage();
            if (resMessage != null) {
                this.postProcessResponse(headerSource, resMessage);
            }
            SOAPMessage sOAPMessage = resMessage;
            return sOAPMessage;
        }
        catch (Exception ex) {
            SOAPMessage resMessage = MessageContextAssociation.peekMessageContext().getSOAPMessage();
            if (resMessage == null || !SOAPUtils.isFaultMessage(resMessage)) {
                CommonBindingProvider bindingProvider = new CommonBindingProvider(sepMetaData);
                CommonBinding binding = bindingProvider.getCommonBinding();
                resMessage = binding.bindFaultMessage(ex);
            }
            if (resMessage != null) {
                this.postProcessResponse(headerSource, resMessage);
            }
            SOAPMessage sOAPMessage = resMessage;
            return sOAPMessage;
        }
        finally {
            try {
                SOAPMessage resMessage = MessageContextAssociation.peekMessageContext().getSOAPMessage();
                if (resMessage != null) {
                    if (SOAPUtils.isFaultMessage(resMessage)) {
                        this.processFaultMetrics(ep, beginProcessing);
                    } else {
                        this.processResponseMetrics(ep, beginProcessing);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PROCESS_METRICS", (Object[])new Object[0]), (Throwable)ex);
            }
            if (debugEnabled) {
                log.debug((Object)("END handleRequest: " + ep.getName()));
            }
        }
    }

    private long initRequestMetrics(Endpoint endpoint) {
        long beginTime = 0L;
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            beginTime = metrics.processRequestMessage();
        }
        return beginTime;
    }

    private void processResponseMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processResponseMessage(beginTime);
        }
    }

    private void processFaultMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processFaultMessage(beginTime);
        }
    }

    private void postProcessResponse(MimeHeaderSource headerSource, SOAPMessage resMessage) {
        try {
            if (headerSource != null) {
                resMessage.saveChanges();
                headerSource.setMimeHeaders(resMessage.getMimeHeaders());
            }
            MessageTrace.traceMessage("Outgoing Response Message", resMessage);
        }
        catch (Exception ex) {
            WSException.rethrow("Faild to post process response message", ex);
        }
    }

    public void handleWSDLRequest(Endpoint endpoint, OutputStream outStream, InvocationContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleWSDLRequest: " + endpoint.getName()));
        }
        try {
            if (this.validInvocationContext(context)) {
                String resourcePath = this.getResourcePath(context);
                URL requestURL = this.getRequestURL(endpoint, context);
                this.handleWSDLRequest(endpoint, outStream, resourcePath, requestURL);
            } else {
                String epAddress = endpoint.getAddress();
                if (epAddress == null) {
                    throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_ENDPOINT_ADDRESS", (Object[])new Object[]{epAddress}));
                }
                URL wsdlUrl = new URL(epAddress + "?wsdl");
                IOUtils.copyStream((OutputStream)outStream, (InputStream)wsdlUrl.openStream());
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (IOException ex) {
            throw new WSException(ex);
        }
    }

    private URL getRequestURL(Endpoint endpoint, InvocationContext context) throws MalformedURLException {
        URL requestURL = null;
        if (context instanceof ServletRequestContext) {
            ServletRequestContext reqContext = (ServletRequestContext)context;
            HttpServletRequest req = reqContext.getHttpServletRequest();
            requestURL = new URL(req.getRequestURL().toString());
        } else if (context.getProperty("org.jboss.ws.http.netty.Message") != null) {
            requestURL = new URL(endpoint.getAddress());
        }
        return requestURL;
    }

    private String getResourcePath(InvocationContext context) {
        String resourcePath = null;
        if (context instanceof ServletRequestContext) {
            ServletRequestContext reqContext = (ServletRequestContext)context;
            HttpServletRequest req = reqContext.getHttpServletRequest();
            resourcePath = req.getParameter("resource");
        } else if (context.getProperty("org.jboss.ws.http.netty.Message") != null) {
            return null;
        }
        return resourcePath;
    }

    private boolean validInvocationContext(InvocationContext context) {
        if (context == null) {
            return false;
        }
        boolean servletInvocationContext = context instanceof ServletRequestContext;
        boolean nettyInvocationContext = context.getProperty("org.jboss.ws.http.netty.Message") != null;
        return servletInvocationContext || nettyInvocationContext;
    }

    private void handleWSDLRequest(Endpoint endpoint, OutputStream outputStream, String resPath, URL reqURL) throws MalformedURLException, IOException {
        ServerEndpointMetaData epMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
        if (epMetaData == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_ENDPOINTMD", (Object[])new Object[0]));
        }
        URL wsdlLocation = epMetaData.getServiceMetaData().getWsdlLocation();
        String wsdlPublishLoc = epMetaData.getServiceMetaData().getWsdlPublishLocation();
        WSDLRequestHandler wsdlRequestHandler = new WSDLRequestHandler(wsdlLocation, wsdlPublishLoc, this.serverConfig);
        Document document = wsdlRequestHandler.getDocumentForPath(reqURL, resPath);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        new DOMWriter((Writer)writer, "UTF-8").setPrettyprint(true).print((Node)document);
    }

    private void handleException(Exception ex) throws ServletException {
        log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_PROCESSING_WEB_SERVICE_REQUEST", (Object[])new Object[0]), (Throwable)ex);
        if (ex instanceof JAXRPCException) {
            throw (JAXRPCException)ex;
        }
        throw new ServletException((Throwable)ex);
    }
}

