/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.wsdl.Definition;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.common.utils.AbstractWSDLFilePublisher;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.tools.wsdl.WSDLWriter;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.w3c.dom.Document;

public class WSDLFilePublisher
extends AbstractWSDLFilePublisher {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSDLFilePublisher.class);
    private static final Logger log = Logger.getLogger(WSDLFilePublisher.class);

    public WSDLFilePublisher(ArchiveDeployment dep) {
        super(dep);
    }

    public void publishWsdlFiles(UnifiedMetaData wsMetaData) throws IOException {
        String deploymentName = this.dep.getCanonicalName();
        for (ServiceMetaData serviceMD : wsMetaData.getServices()) {
            String publishLocation;
            String wsdlLocation = this.getWSDLLocation(serviceMD);
            File wsdlFile = this.getPublishLocation(deploymentName, wsdlLocation, publishLocation = serviceMD.getWsdlPublishLocation());
            if (wsdlFile == null) continue;
            wsdlFile.getParentFile().mkdirs();
            Writer fWriter = null;
            try {
                fWriter = IOUtils.getCharsetFileWriter((File)wsdlFile, (String)"UTF-8");
                WSDLDefinitions wsdlDefinitions = serviceMD.getWsdlDefinitions();
                new WSDLWriter(wsdlDefinitions).write(fWriter, "UTF-8");
                URL wsdlPublishURL = wsdlFile.toURI().toURL();
                log.info((Object)("WSDL published to: " + wsdlPublishURL));
                serviceMD.setWsdlLocation(wsdlPublishURL);
                Definition wsdl11Definition = wsdlDefinitions.getWsdlOneOneDefinition();
                if (wsdl11Definition != null) {
                    LinkedList published = new LinkedList();
                    this.publishWsdlImports(wsdlPublishURL, wsdl11Definition, published);
                    Document document = wsdlDefinitions.getWsdlDocument();
                    this.publishSchemaImports(wsdlPublishURL, document.getDocumentElement(), published);
                    continue;
                }
                throw new UnsupportedOperationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_SUPPORTED_WSDL20", (Object[])new Object[0]));
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PUBLISH_WSDL", (Object[])new Object[]{wsdlFile}), e);
            }
            finally {
                if (fWriter == null) continue;
                fWriter.close();
            }
        }
    }

    private String getWSDLLocation(ServiceMetaData serviceMD) {
        if (serviceMD.getWsdlFileOrLocation() == null) {
            return null;
        }
        return serviceMD.getWsdlFileOrLocation().toExternalForm();
    }

    private File getPublishLocation(String archiveName, String wsdlLocation, String wsdlPublishLocation) throws IOException {
        File result;
        String publishLocation;
        if (wsdlLocation == null) {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_WSDL_PUBLISH_LOCATION", (Object[])new Object[0]));
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Publishing WSDL file: " + wsdlLocation));
        }
        boolean predefinedLocation = (publishLocation = wsdlPublishLocation) != null && publishLocation.startsWith("file:");
        File locationFile = null;
        if (!predefinedLocation) {
            if (archiveName.startsWith("http://")) {
                archiveName = archiveName.replace("http://", "http-");
            }
            locationFile = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + archiveName);
        } else {
            try {
                locationFile = new File(new URL(publishLocation).getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_PUBLISH_LOCATION", (Object[])new Object[]{e.getMessage()}));
            }
        }
        if (wsdlLocation.indexOf(this.expLocation) >= 0) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.indexOf(this.expLocation) + this.expLocation.length());
            result = new File(locationFile + "/" + wsdlLocation);
        } else if (wsdlLocation.startsWith("vfs:") || wsdlLocation.startsWith("vfsfile:") || wsdlLocation.startsWith("file:") || wsdlLocation.startsWith("jar:") || wsdlLocation.startsWith("vfszip:")) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.lastIndexOf("/") + 1);
            result = new File(locationFile + "/" + wsdlLocation);
        } else {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_WSDLFILE_", (Object[])new Object[]{wsdlLocation, this.expLocation}));
        }
        return result;
    }
}

