/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.api.operation;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.gatein.management.api.binding.BindingException;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationAttachment;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.ResultHandler;

public abstract class UpdateOperationHandler<T>
implements OperationHandler {
    @Override
    public void execute(OperationContext operationContext, ResultHandler resultHandler) throws ResourceNotFoundException, OperationException {
        OperationAttachment attachment = operationContext.getAttachment(true);
        Class<T> type = this.getParameterizedType();
        Marshaller<T> marshaller = operationContext.getBindingProvider().getMarshaller(type, operationContext.getContentType());
        if (marshaller == null) {
            throw new OperationException(operationContext.getOperationName(), "No marshaller found for type " + type + " and content type " + (Object)((Object)operationContext.getContentType()) + " at address " + operationContext.getAddress());
        }
        try {
            this.execute(operationContext, marshaller.unmarshal(attachment.getStream()));
        }
        catch (BindingException e) {
            throw new OperationException(operationContext.getOperationName(), "Exception unmarshalling data for type " + type + " and content type " + (Object)((Object)operationContext.getContentType()) + " at address " + operationContext.getAddress(), e);
        }
    }

    protected abstract void execute(OperationContext var1, T var2) throws ResourceNotFoundException, OperationException;

    private Class<T> getParameterizedType() {
        for (Class<?> clazz = this.getClass(); clazz != UpdateOperationHandler.class; clazz = clazz.getSuperclass()) {
            Type t = clazz.getGenericSuperclass();
            if (!(t instanceof ParameterizedType)) continue;
            return (Class)((ParameterizedType)t).getActualTypeArguments()[0];
        }
        return null;
    }
}

