/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.api.operation.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gatein.management.api.operation.model.NamedDescription;

public class ReadResourceModel {
    private String description;
    private List<NamedDescription> operations;
    private List<NamedDescription> children;
    private boolean childDescriptionsSet;

    public ReadResourceModel(String description, Set<String> childNames) {
        if (description == null) {
            throw new IllegalArgumentException("description was null");
        }
        if (childNames == null) {
            throw new IllegalArgumentException("childNames was null");
        }
        this.description = description;
        this.children = new ArrayList<NamedDescription>(childNames.size());
        for (String childName : childNames) {
            this.children.add(new NamedDescription(childName, null));
        }
        this.childDescriptionsSet = false;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getChildren() {
        LinkedHashSet<String> childNames = new LinkedHashSet<String>(this.children.size());
        for (NamedDescription nd : this.children) {
            childNames.add(nd.getName());
        }
        return Collections.unmodifiableSet(childNames);
    }

    public List<NamedDescription> getOperations() {
        if (this.operations == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.operations);
    }

    public void addOperation(NamedDescription namedDescription) {
        if (this.operations == null) {
            this.operations = new ArrayList<NamedDescription>();
        }
        this.operations.add(namedDescription);
    }

    public NamedDescription getChildDescription(String childName) {
        return this.findNamedDescription(childName, this.children);
    }

    public List<NamedDescription> getChildDescriptions() {
        return Collections.unmodifiableList(this.children);
    }

    public void setChildDescription(String name, String description) {
        NamedDescription found = this.findNamedDescription(name, this.children);
        if (found != null) {
            found.setDescription(description);
            this.childDescriptionsSet = true;
        }
    }

    public boolean isChildDescriptionsSet() {
        return this.childDescriptionsSet;
    }

    private NamedDescription findNamedDescription(String name, List<NamedDescription> namedDescriptions) {
        for (NamedDescription nd : namedDescriptions) {
            if (!name.equals(nd.getName())) continue;
            return nd;
        }
        return null;
    }
}

