/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.bindings.jboss.auth.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAML20TokenAttributeProvider;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML20TokenRoleAttributeProvider
implements SAML20TokenAttributeProvider {
    private static Logger logger = Logger.getLogger(SAML20TokenRoleAttributeProvider.class);
    public static final String JBOSS_ROLE_PRINCIPAL_NAME = "Roles";
    public static final String DEFAULT_TOKEN_ROLE_ATTRIBUTE_NAME = "role";
    private String tokenRoleAttributeName;

    public void setProperties(Map<String, String> properties) {
        String roleAttrKey = String.valueOf(this.getClass().getName()) + ".tokenRoleAttributeName";
        this.tokenRoleAttributeName = properties.get(roleAttrKey);
        if (this.tokenRoleAttributeName == null) {
            this.tokenRoleAttributeName = DEFAULT_TOKEN_ROLE_ATTRIBUTE_NAME;
        }
    }

    public AttributeStatementType getAttributeStatement() {
        Subject subject = SecurityActions.getSecurityContext().getSubjectInfo().getAuthenticatedSubject();
        if (subject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No authentication Subject found, cannot provide any user roles!");
            }
            return null;
        }
        AttributeStatementType attributeStatement = new AttributeStatementType();
        AttributeType rolesAttribute = new AttributeType(this.tokenRoleAttributeName);
        attributeStatement.addAttribute(new AttributeStatementType.ASTChoiceType(rolesAttribute));
        for (Principal rolePrincipal : subject.getPrincipals()) {
            if (!JBOSS_ROLE_PRINCIPAL_NAME.equalsIgnoreCase(rolePrincipal.getName())) continue;
            Group simpleGroup = (Group)rolePrincipal;
            Enumeration members = simpleGroup.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                rolesAttribute.addAttributeValue((Object)role.getName());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning an AttributeStatement with a [" + this.tokenRoleAttributeName + "] attribute containing: " + rolesAttribute.getAttributeValue()));
        }
        return attributeStatement;
    }
}

