/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.service.BundleInstallIntegration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

public class OSGiBundleInfoParseProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        String contextName = depUnit.getName();
        BundleInfo info = (BundleInfo)depUnit.getAttachment(OSGiConstants.BUNDLE_INFO_KEY);
        Deployment deployment = BundleInstallIntegration.getDeployment(contextName);
        if (info != null || deployment != null) {
            return;
        }
        Manifest manifest = (Manifest)depUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (manifest != null) {
            try {
                org.jboss.vfs.VirtualFile virtualFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
                info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)contextName);
                depUnit.putAttachment(OSGiConstants.BUNDLE_INFO_KEY, (Object)info);
            }
            catch (BundleException ex) {
                throw OSGiMessages.MESSAGES.cannotCreateBundleDeployment(ex, depUnit);
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        depUnit.removeAttachment(OSGiConstants.BUNDLE_INFO_KEY);
    }
}

