/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.deployment.BundleContextBindingProcessor;
import org.jboss.as.osgi.deployment.BundleDeploymentProcessor;
import org.jboss.as.osgi.deployment.BundleInstallProcessor;
import org.jboss.as.osgi.deployment.ModuleRegisterProcessor;
import org.jboss.as.osgi.deployment.OSGiBundleInfoParseProcessor;
import org.jboss.as.osgi.deployment.OSGiManifestStructureProcessor;
import org.jboss.as.osgi.deployment.OSGiXServiceParseProcessor;
import org.jboss.as.osgi.management.OSGiRuntimeResource;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.osgi.service.PersistentBundlesIntegration;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class OSGiSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final OSGiSubsystemAdd INSTANCE = new OSGiSubsystemAdd();
    private OSGiRuntimeResource resource;

    private OSGiSubsystemAdd() {
    }

    protected Resource createResource(OperationContext context) {
        this.resource = new OSGiRuntimeResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)this.resource);
        return this.resource;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        if (operation.has("activation")) {
            model.get("activation").set(operation.get("activation"));
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        OSGiLogger.LOGGER.infoActivatingSubsystem();
        final ServiceTarget serviceTarget = context.getServiceTarget();
        SubsystemState.Activation activationMode = this.getActivationMode(operation);
        final PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker = new PersistentBundlesIntegration.InitialDeploymentTracker(context, activationMode);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                newControllers.add(PersistentBundlesIntegration.addService(serviceTarget, deploymentTracker));
                newControllers.add(FrameworkBootstrapService.addService(serviceTarget, OSGiSubsystemAdd.this.resource, verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("osgi", Phase.STRUCTURE, 1536, (DeploymentUnitProcessor)new OSGiManifestStructureProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 2304, (DeploymentUnitProcessor)new OSGiBundleInfoParseProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 2560, (DeploymentUnitProcessor)new OSGiXServiceParseProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 2688, (DeploymentUnitProcessor)new BundleDeploymentProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.INSTALL, 6656, (DeploymentUnitProcessor)new BundleContextBindingProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.INSTALL, 1536, (DeploymentUnitProcessor)new BundleInstallProcessor(deploymentTracker));
                processorTarget.addDeploymentProcessor("osgi", Phase.INSTALL, 1616, (DeploymentUnitProcessor)new ModuleRegisterProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        newControllers.add(SubsystemState.addService(serviceTarget, activationMode));
    }

    private SubsystemState.Activation getActivationMode(ModelNode operation) {
        SubsystemState.Activation activation = SubsystemState.DEFAULT_ACTIVATION;
        if (operation.has("activation")) {
            activation = SubsystemState.Activation.valueOf(operation.get("activation").asString().toUpperCase(Locale.ENGLISH));
        }
        return activation;
    }
}

