/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiDescriptionProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiFrameworkPropertyRemove
extends AbstractRemoveStepHandler {
    static final OSGiFrameworkPropertyRemove INSTANCE = new OSGiFrameworkPropertyRemove();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            node.get("operation-name").set("remove");
            node.get("description").set(OSGiDescriptionProviders.getResourceBundle(locale).getString("framework.property.remove"));
            node.get("request-properties").setEmptyObject();
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private OSGiFrameworkPropertyRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final String propName = operation.get("address").asObject().get("property").asString();
        final SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState == null) {
            context.setRollbackOnly();
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        final Object oldVal = subsystemState.setProperty(propName, null);
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                subsystemState.setProperty(propName, oldVal);
            }
        });
    }
}

