/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityInsertAction
extends EntityAction {
    private Object[] state;
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Serializable id, Object[] state, Object instance, Object version, EntityPersister persister, SessionImplementor session) throws HibernateException {
        super(session, id, instance, persister);
        this.state = state;
        this.version = version;
    }

    public Object[] getState() {
        return this.state;
    }

    @Override
    public void execute() throws HibernateException {
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        Serializable id = this.getId();
        boolean veto = this.preInsert();
        if (!veto) {
            persister.insert(id, this.state, instance, session);
            EntityEntry entry = session.getPersistenceContext().getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible nonthreadsafe access to session");
            }
            entry.postInsert();
            if (persister.hasInsertGeneratedProperties()) {
                persister.processInsertGeneratedProperties(id, instance, this.state, session);
                if (persister.isVersionPropertyGenerated()) {
                    this.version = Versioning.getVersion(this.state, persister);
                }
                entry.postUpdate(instance, this.state, this.version);
            }
            this.getSession().getPersistenceContext().registerInsertedKey(this.getPersister(), this.getId());
        }
        SessionFactoryImplementor factory = this.getSession().getFactory();
        if (this.isCachePutEnabled(persister, session)) {
            CacheEntry ce = new CacheEntry(this.state, persister, persister.hasUninitializedLazyProperties(instance), this.version, session, instance);
            this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
            CacheKey ck = session.generateCacheKey(id, persister.getIdentifierType(), persister.getRootEntityName());
            boolean put = persister.getCacheAccessStrategy().insert(ck, this.cacheEntry, this.version);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
            }
        }
        this.postInsert();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    private void postInsert() {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            listener.onPostInsert(event);
        }
    }

    private void postCommitInsert() {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            listener.onPostInsert(event);
        }
    }

    private boolean preInsert() {
        boolean veto = false;
        EventListenerGroup<PreInsertEventListener> listenerGroup = this.listenerGroup(EventType.PRE_INSERT);
        if (listenerGroup.isEmpty()) {
            return veto;
        }
        PreInsertEvent event = new PreInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.eventSource());
        for (PreInsertEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreInsert(event);
        }
        return veto;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SessionImplementor session) throws HibernateException {
        EntityPersister persister = this.getPersister();
        if (success && this.isCachePutEnabled(persister, this.getSession())) {
            CacheKey ck = this.getSession().generateCacheKey(this.getId(), persister.getIdentifierType(), persister.getRootEntityName());
            boolean put = persister.getCacheAccessStrategy().afterInsert(ck, this.cacheEntry, this.version);
            if (put && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
            }
        }
        this.postCommitInsert();
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        return !this.listenerGroup(EventType.POST_COMMIT_INSERT).isEmpty();
    }

    private boolean isCachePutEnabled(EntityPersister persister, SessionImplementor session) {
        return persister.hasCache() && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }
}

