/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.resolver.FelixResolveContext;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;

public class Util {
    public static String getSymbolicName(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return cap.getAttributes().get("osgi.identity").toString();
        }
        return null;
    }

    public static Version getVersion(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return (Version)cap.getAttributes().get("version");
        }
        return null;
    }

    public static boolean isFragment(Resource resource) {
        Capability icap = (Capability)resource.getCapabilities("osgi.identity").get(0);
        String type = (String)icap.getAttributes().get("type");
        return "osgi.fragment".equals(type);
    }

    public static boolean isOptional(Requirement req) {
        String resolution = (String)req.getDirectives().get("resolution");
        return "optional".equals(resolution);
    }

    public static List<Requirement> getDynamicRequirements(List<Requirement> reqs) {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        if (reqs != null) {
            for (Requirement req : reqs) {
                String resolution = (String)req.getDirectives().get("resolution");
                if (resolution == null || !resolution.equals("dynamic")) continue;
                result.add(req);
            }
        }
        return result;
    }

    public static Capability getSatisfyingCapability(FelixResolveContext env, Resource br, Requirement req) {
        List caps;
        Wiring wiring = (Wiring)env.getWirings().get(br);
        List list = caps = wiring != null ? wiring.getResourceCapabilities(null) : br.getCapabilities(null);
        if (caps != null) {
            for (Capability cap : caps) {
                if (!cap.getNamespace().equals(req.getNamespace()) || !env.matches(req, cap)) continue;
                return cap;
            }
        }
        return null;
    }
}

