/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;

public class AliasOperationTransformer
implements OperationTransformer {
    private final AddressTransformer transformer;

    protected AliasOperationTransformer(AddressTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode original) {
        ModelNode operation = original.clone();
        PathAddress transformedAddress = this.transformer.transformAddress(address);
        operation.get("address").set(transformedAddress.toModelNode());
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    public static AliasOperationTransformer replaceLastElement(final PathElement element) {
        return AliasOperationTransformer.create(new AddressTransformer(){

            @Override
            public PathAddress transformAddress(PathAddress original) {
                PathAddress address = original.subAddress(0, original.size() - 1);
                return address.append(element);
            }
        });
    }

    public static AliasOperationTransformer create(AddressTransformer transformer) {
        return new AliasOperationTransformer(transformer);
    }

    public static interface AddressTransformer {
        public PathAddress transformAddress(PathAddress var1);
    }
}

