/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.jboss.as.web.security.SecurityActions;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SecurityUtil;
import org.jboss.security.SimplePrincipal;

public class SecurityContextAssociationValve
extends ValveBase {
    private final String securityDomain;
    private final Map<String, RunAsIdentityMetaData> runAsIdentity;
    private final String contextId;
    private static final ThreadLocal<Request> activeRequest = new ThreadLocal();

    public SecurityContextAssociationValve(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        String securityDomain = SecurityUtil.unprefixSecurityDomain((String)metaData.getSecurityDomain());
        if (securityDomain == null) {
            securityDomain = "jboss-web-policy";
        }
        String contextId = deploymentUnit.getName();
        if (deploymentUnit.getParent() != null) {
            contextId = deploymentUnit.getParent().getName() + "!" + contextId;
        }
        this.securityDomain = securityDomain;
        this.runAsIdentity = metaData.getRunAsIdentity();
        this.contextId = contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        activeRequest.set(request);
        Session session = null;
        Principal caller = request.getPrincipal();
        JBossGenericPrincipal principal = null;
        HttpSession hsession = request.getSession(false);
        WebLogger.WEB_SECURITY_LOGGER.tracef("Begin invoke, caller=" + caller, new Object[0]);
        boolean createdSecurityContext = false;
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            createdSecurityContext = true;
            sc = SecurityActions.createSecurityContext(this.securityDomain);
            SecurityActions.setSecurityContextOnAssociation(sc);
        }
        String previousContextID = null;
        try {
            Wrapper servlet = null;
            try {
                Manager manager;
                servlet = request.getWrapper();
                if (servlet != null) {
                    String name = servlet.getName();
                    RunAsIdentityMetaData identity = this.runAsIdentity.get(name);
                    RunAsIdentity runAsIdentity = null;
                    if (identity != null) {
                        WebLogger.WEB_SECURITY_LOGGER.tracef(name + ", runAs: " + identity, new Object[0]);
                        runAsIdentity = new RunAsIdentity(identity.getRoleName(), identity.getPrincipalName(), identity.getRunAsRoles());
                    }
                    SecurityActions.pushRunAsIdentity(runAsIdentity);
                }
                if ((manager = this.container.getManager()) != null && hsession != null) {
                    try {
                        session = manager.findSession(hsession.getId());
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                if (caller == null || !(caller instanceof JBossGenericPrincipal)) {
                    Session sessionInternal;
                    if (session != null) {
                        principal = (JBossGenericPrincipal)((Object)session.getPrincipal());
                    }
                    if (principal == null && (sessionInternal = request.getSessionInternal(false)) != null) {
                        principal = (JBossGenericPrincipal)((Object)sessionInternal.getNote("org.apache.catalina.authenticator.PRINCIPAL"));
                    }
                } else {
                    principal = (JBossGenericPrincipal)((Object)caller);
                }
                if (principal != null) {
                    WebLogger.WEB_SECURITY_LOGGER.tracef("Restoring principal info from cache", new Object[0]);
                    if (createdSecurityContext) {
                        sc.getUtil().createSubjectInfo((Principal)new SimplePrincipal(principal.getName()), principal.getCredentials(), principal.getSubject());
                    }
                }
            }
            catch (Throwable e) {
                WebLogger.WEB_SECURITY_LOGGER.debug("Failed to determine servlet", e);
            }
            previousContextID = this.setContextID(this.contextId);
            this.getNext().invoke(request, response);
            if (servlet != null) {
                SecurityActions.popRunAsIdentity();
            }
        }
        finally {
            WebLogger.WEB_SECURITY_LOGGER.tracef("End invoke, caller=" + caller, new Object[0]);
            SecurityActions.clearSecurityContext();
            SecurityRolesAssociation.setSecurityRoles(null);
            this.setContextID(previousContextID);
            activeRequest.set(null);
        }
    }

    public static Request getActiveRequest() {
        return activeRequest.get();
    }

    private String setContextID(String contextID) {
        if (System.getSecurityManager() == null) {
            String previousContext = PolicyContext.getContextID();
            PolicyContext.setContextID((String)contextID);
            return previousContext;
        }
        SetContextIDAction action = new SetContextIDAction(contextID);
        return AccessController.doPrivileged(action);
    }

    private static class SetContextIDAction
    implements PrivilegedAction<String> {
        private String contextID;

        SetContextIDAction(String contextID) {
            this.contextID = contextID;
        }

        @Override
        public String run() {
            String currentContextID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return currentContextID;
        }
    }
}

