/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap.api;

import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.APITestContext;
import org.picketlink.idm.impl.api.GroupQueryTest;
import org.picketlink.idm.impl.api.PersistenceManagerTest;
import org.picketlink.idm.impl.api.RelationshipManagerTest;
import org.picketlink.idm.impl.api.RoleManagerTest;
import org.picketlink.idm.impl.api.RoleQueryTest;
import org.picketlink.idm.impl.api.UserQueryTest;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.test.support.IdentityTestPOJO;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;
import org.picketlink.idm.test.support.ldap.LDAPTestPOJO;

public class APILDAPTestCase
extends IdentityTestPOJO
implements APITestContext {
    PersistenceManagerTest persistenceManagerTest;
    RelationshipManagerTest relationshipManagerTest;
    RoleManagerTest roleManagerTest;
    UserQueryTest userQueryTest;
    GroupQueryTest groupQueryTest;
    RoleQueryTest roleQueryTest;
    IdentitySessionFactory identitySessionFactory;
    HibernateTestPOJO hibernateTest = new HibernateTestPOJO();
    LDAPTestPOJO ldapTestPOJO = new LDAPTestPOJO();

    public void setUp() throws Exception {
        super.start();
        this.hibernateTest.start();
        this.ldapTestPOJO.start();
        this.identityConfig = this.ldapTestPOJO.getIdentityConfig();
        this.persistenceManagerTest = new PersistenceManagerTest((APITestContext)this);
        this.relationshipManagerTest = new RelationshipManagerTest((APITestContext)this);
        this.roleManagerTest = new RoleManagerTest((APITestContext)this);
        this.userQueryTest = new UserQueryTest((APITestContext)this);
        this.groupQueryTest = new GroupQueryTest((APITestContext)this);
        this.roleQueryTest = new RoleQueryTest((APITestContext)this);
        this.setRealmName("realm://RedHat/DB_LDAP");
        this.ldapTestPOJO.populateClean();
        this.identitySessionFactory = new IdentityConfigurationImpl().configure(this.getIdentityConfig()).buildIdentitySessionFactory();
    }

    public void tearDown() throws Exception {
        super.stop();
        this.ldapTestPOJO.stop();
        this.hibernateTest.stop();
    }

    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    public void testPersistenceManager() throws Exception {
        this.persistenceManagerTest.testMethods(this.getRealmName());
    }

    public void testRelationshipManager() throws Exception {
        this.relationshipManagerTest.testMethods(this.getRealmName());
    }

    public void testRelationshipManagerCascade() throws Exception {
        this.relationshipManagerTest.testCascade(this.getRealmName());
    }

    public void testRelationshipManagerMergedRoleAssociations() throws Exception {
        this.relationshipManagerTest.testMergedRoleAssociations(this.getRealmName());
    }

    public void testRoleManager() throws Exception {
        this.roleManagerTest.testMethods(this.getRealmName());
    }

    public void testUserQuery() throws Exception {
        this.userQueryTest.testQuery(this.getRealmName());
    }

    public void testGroupQuery() throws Exception {
        this.groupQueryTest.testQuery(this.getRealmName());
    }

    public void testRoleQuery() throws Exception {
        this.roleQueryTest.testQuery(this.getRealmName());
    }

    public void testCaseSensitiveNames() throws Exception {
        IdentitySession session = this.identitySessionFactory.createIdentitySession(this.getRealmName());
        this.begin();
        User aaa = session.getPersistenceManager().createUser("aaa");
        session.getAttributesManager().updatePassword(aaa, "Password2000Toto5");
        APILDAPTestCase.assertNull((Object)session.getPersistenceManager().findUser("bbb"));
        APILDAPTestCase.assertNotNull((Object)session.getPersistenceManager().findUser("aaa"));
        APILDAPTestCase.assertNull((Object)session.getPersistenceManager().findUser("aAa"));
        session.getAttributesManager().validatePassword((User)new SimpleUser("aAa"), "Password2000Toto5");
        APILDAPTestCase.assertNull((Object)session.getPersistenceManager().findUser("aAa"));
        this.commit();
    }

    public void begin() {
        this.hibernateTest.begin();
    }

    public void commit() {
        this.hibernateTest.commit();
    }

    public void overrideFromProperties() throws Exception {
    }
}

