/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap.api;

import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.impl.api.APITestContext;
import org.picketlink.idm.impl.api.OrganizationTest;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.test.support.IdentityTestPOJO;
import org.picketlink.idm.test.support.hibernate.HibernateTestPOJO;
import org.picketlink.idm.test.support.ldap.LDAPTestPOJO;

public class OrganizationLDAPTestCase
extends IdentityTestPOJO
implements APITestContext {
    private OrganizationTest orgTest;
    private IdentitySessionFactory identitySessionFactory;
    private String samplePortalRealmName = "realm://portal/SamplePortal/DB_LDAP";
    private String sampleOrganizationRealmName = "realm://RedHat/DB_LDAP";
    HibernateTestPOJO hibernateTest = new HibernateTestPOJO();
    LDAPTestPOJO ldapTestPOJO = new LDAPTestPOJO();

    public void setUp() throws Exception {
        super.start();
        this.hibernateTest.start();
        this.ldapTestPOJO.start();
        this.identityConfig = this.ldapTestPOJO.getIdentityConfig();
        this.orgTest = new OrganizationTest((APITestContext)this);
        this.ldapTestPOJO.populateClean();
        this.identitySessionFactory = new IdentityConfigurationImpl().configure(this.getIdentityConfig()).buildIdentitySessionFactory();
    }

    public void tearDown() throws Exception {
        super.stop();
        this.ldapTestPOJO.stop();
        this.hibernateTest.stop();
    }

    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    public void testOrganization() throws Exception {
        this.orgTest.testRedHatOrganization(this.getSampleOrganizationRealmName());
    }

    public void testSamplePortal() throws Exception {
        this.orgTest.testSamplePortal(this.getSamplePortalRealmName());
    }

    public String getSamplePortalRealmName() {
        return this.samplePortalRealmName;
    }

    public void setSamplePortalRealmName(String samplePortalRealmName) {
        this.samplePortalRealmName = samplePortalRealmName;
    }

    public String getSampleOrganizationRealmName() {
        return this.sampleOrganizationRealmName;
    }

    public void setSampleOrganizationRealmName(String sampleOrganizationRealmName) {
        this.sampleOrganizationRealmName = sampleOrganizationRealmName;
    }

    public void begin() {
        this.hibernateTest.begin();
    }

    public void commit() {
        this.hibernateTest.commit();
    }

    public void overrideFromProperties() throws Exception {
    }
}

