/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config;

import org.ocpsoft.common.util.Assert;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.bind.ParameterizedPattern;
import org.ocpsoft.rewrite.bind.RegexCapture;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.servlet.config.HttpOperation;
import org.ocpsoft.rewrite.servlet.config.ISubstitute;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.util.ParameterStore;

public class Substitute
extends HttpOperation
implements ISubstitute {
    private final ParameterizedPattern location;
    private final ParameterStore<ISubstitute.SubstituteParameter> parameters = new ParameterStore();

    private Substitute(String location) {
        Assert.notNull(location, "Location must not be null.");
        this.location = new ParameterizedPattern("[^/]+", location);
        for (RegexCapture parameter : this.location.getParameters().values()) {
            this.where(parameter.getName()).bindsTo(Evaluation.property(parameter.getName()));
        }
    }

    public static Substitute with(String location) {
        return new Substitute(location);
    }

    @Override
    public void performHttp(HttpServletRewrite event, EvaluationContext context) {
        if (event instanceof HttpInboundServletRewrite) {
            String target = this.location.build(event, context, this.parameters.getParameters());
            ((HttpInboundServletRewrite)event).forward(target);
        } else if (event instanceof HttpOutboundServletRewrite) {
            String target = this.location.build(event, context, this.parameters.getParameters());
            if (((HttpOutboundServletRewrite)event).getOutboundURL().startsWith(event.getContextPath()) && target.startsWith("/") && !target.startsWith(event.getContextPath())) {
                target = event.getContextPath() + target;
            }
            ((HttpOutboundServletRewrite)event).setOutboundURL(target);
        }
    }

    @Override
    public ISubstitute.SubstituteParameter where(String param) {
        return this.parameters.where(param, new ISubstitute.SubstituteParameter(this, this.location.getParameter(param)));
    }

    @Override
    public ISubstitute.SubstituteParameter where(String param, Binding binding) {
        return (ISubstitute.SubstituteParameter)this.where(param).bindsTo(binding);
    }

    @Override
    public ParameterizedPattern getTargetExpression() {
        return this.location;
    }
}

