/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import javax.xml.stream.XMLStreamException;
import org.hornetq.api.core.SimpleString;
import org.jboss.as.messaging.Element;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class ElementUtils {
    ElementUtils() {
    }

    static void writeSimpleElement(Element element, String content, XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (content != null && content.length() > 0) {
            streamWriter.writeStartElement(element.getLocalName());
            streamWriter.writeCharacters(content);
            streamWriter.writeEndElement();
        }
    }

    static void writeSimpleElement(Element element, SimpleString content, XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (content != null) {
            ElementUtils.writeSimpleElement(element, content.toString(), streamWriter);
        }
    }

    static enum StaxEvent {
        START_ELEMENT(1),
        END_ELEMENT(2),
        PROCESSING_INSTRUCTION(3),
        CHARACTERS(4),
        COMMENT(5),
        SPACE(6),
        START_DOCUMENT(7),
        END_DOCUMENT(8),
        ENTITY_REFERENCE(9),
        ATTRIBUTE(10),
        DTD(11),
        CDATA(12),
        NAMESPACE(13),
        NOTATION_DECLARATION(14),
        ENTITY_DECLARATION(15);

        private static StaxEvent[] EVENTS;
        private final int tag;

        private StaxEvent(int tag) {
            this.tag = tag;
        }

        static StaxEvent tagToEvent(int tag) {
            return EVENTS[tag - 1];
        }

        static {
            EVENTS = StaxEvent.values();
        }
    }
}

