/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.spi.core.naming.BindingRegistry;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Values;

public class AS7BindingRegistry
implements BindingRegistry {
    private final ServiceContainer container;

    public AS7BindingRegistry(ServiceContainer container) {
        this.container = container;
    }

    public Object getContext() {
        return null;
    }

    public void setContext(Object ctx) {
    }

    public Object lookup(String name) {
        return null;
    }

    public boolean bind(String name, Object obj) {
        if (name == null || name.isEmpty()) {
            throw MessagingMessages.MESSAGES.cannotBindJndiName();
        }
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        this.container.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addInjection(binderService.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory(Values.immediateValue((Object)obj))).setInitialMode(ServiceController.Mode.ACTIVE).install();
        MessagingLogger.ROOT_LOGGER.boundJndiName(bindInfo.getAbsoluteJndiName());
        return true;
    }

    public void unbind(String name) {
        if (name == null || name.isEmpty()) {
            throw MessagingMessages.MESSAGES.cannotUnbindJndiName();
        }
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        ServiceController bindingService = this.container.getService(bindInfo.getBinderServiceName());
        if (bindingService == null) {
            MessagingLogger.ROOT_LOGGER.debugf("Cannot unbind %s since no binding exists with that name", name);
            return;
        }
        bindingService.setMode(ServiceController.Mode.REMOVE);
        MessagingLogger.ROOT_LOGGER.unboundJndiName(bindInfo.getAbsoluteJndiName());
    }

    public void close() {
    }

    private static class JndiBinding {
        private final String relativeJndiName;
        private final ServiceName jndiContextServiceName;
        private final String cachedToString;

        JndiBinding(ServiceName contextServiceName, String relativeJndiName) {
            if (contextServiceName == null) {
                throw MessagingMessages.MESSAGES.nullVar("contextServiceName");
            }
            if (relativeJndiName == null) {
                throw MessagingMessages.MESSAGES.nullVar("relativeJndiName");
            }
            this.jndiContextServiceName = contextServiceName;
            this.relativeJndiName = relativeJndiName;
            this.cachedToString = this.generateToString();
        }

        static JndiBinding parse(String name) {
            String relativeJndiName = null;
            if (name.startsWith("java:jboss/")) {
                relativeJndiName = name.substring(11);
                return new JndiBinding(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, relativeJndiName);
            }
            if (name.startsWith("java:comp/")) {
                relativeJndiName = name.substring(10);
                return new JndiBinding(ContextNames.COMPONENT_CONTEXT_SERVICE_NAME, relativeJndiName);
            }
            if (name.startsWith("java:module/")) {
                relativeJndiName = name.substring(12);
                return new JndiBinding(ContextNames.MODULE_CONTEXT_SERVICE_NAME, relativeJndiName);
            }
            if (name.startsWith("java:app/")) {
                relativeJndiName = name.substring(9);
                return new JndiBinding(ContextNames.APPLICATION_CONTEXT_SERVICE_NAME, relativeJndiName);
            }
            if (name.startsWith("java:global/")) {
                relativeJndiName = name.substring(12);
                return new JndiBinding(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, relativeJndiName);
            }
            if (name.startsWith("java:/")) {
                relativeJndiName = name.substring(6);
                return new JndiBinding(ContextNames.JAVA_CONTEXT_SERVICE_NAME, relativeJndiName);
            }
            if (name.startsWith("java:")) {
                return null;
            }
            relativeJndiName = name;
            return new JndiBinding(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, "jms/" + relativeJndiName);
        }

        public String toString() {
            return this.cachedToString;
        }

        private String generateToString() {
            StringBuffer sb = new StringBuffer();
            if (this.jndiContextServiceName.equals(ContextNames.JBOSS_CONTEXT_SERVICE_NAME)) {
                sb.append("java:jboss/");
            } else if (this.jndiContextServiceName.equals(ContextNames.APPLICATION_CONTEXT_SERVICE_NAME)) {
                sb.append("java:app/");
            } else if (this.jndiContextServiceName.equals(ContextNames.MODULE_CONTEXT_SERVICE_NAME)) {
                sb.append("java:module/");
            } else if (this.jndiContextServiceName.equals(ContextNames.COMPONENT_CONTEXT_SERVICE_NAME)) {
                sb.append("java:comp/");
            } else if (this.jndiContextServiceName.equals(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME)) {
                sb.append("java:global/");
            }
            sb.append(this.relativeJndiName);
            return sb.toString();
        }
    }
}

