/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.ConnectionFactoryService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JndiEntriesAttribute;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final ConnectionFactoryAdd INSTANCE = new ConnectionFactoryAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : JMSServices.CONNECTION_FACTORY_ATTRS) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ConnectionFactoryConfiguration configuration = ConnectionFactoryAdd.createConfiguration(context, name, model);
        ConnectionFactoryService service = new ConnectionFactoryService(configuration);
        ServiceName serviceName = JMSServices.getConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name});
        newControllers.add(context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.getJmsServer()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static ConnectionFactoryConfiguration createConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        ModelNode lbcn;
        ModelNode entries = CommonAttributes.ENTRIES.resolveModelAttribute(context, model);
        String[] jndiBindings = JndiEntriesAttribute.getJndiBindings(entries);
        ConnectionFactoryConfigurationImpl config = new ConnectionFactoryConfigurationImpl(name, false, jndiBindings);
        config.setHA(CommonAttributes.HA.resolveModelAttribute(context, model).asBoolean());
        config.setAutoGroup(CommonAttributes.AUTO_GROUP.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnAcknowledge(CommonAttributes.BLOCK_ON_ACK.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnDurableSend(CommonAttributes.BLOCK_ON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnNonDurableSend(CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        config.setCacheLargeMessagesClient(CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.resolveModelAttribute(context, model).asBoolean());
        config.setCallTimeout(CommonAttributes.CALL_TIMEOUT.resolveModelAttribute(context, model).asLong());
        config.setClientFailureCheckPeriod((long)CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.resolveModelAttribute(context, model).asInt());
        ModelNode clientId = CommonAttributes.CLIENT_ID.resolveModelAttribute(context, model);
        if (clientId.isDefined()) {
            config.setClientID(clientId.asString());
        }
        config.setCompressLargeMessages(CommonAttributes.COMPRESS_LARGE_MESSAGES.resolveModelAttribute(context, model).asBoolean());
        config.setConfirmationWindowSize(CommonAttributes.CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        config.setConnectionTTL(CommonAttributes.CONNECTION_TTL.resolveModelAttribute(context, model).asLong());
        if (model.hasDefined("connector")) {
            ModelNode connectorRefs = model.get("connector");
            ArrayList<String> connectorNames = new ArrayList<String>();
            for (String connectorName : model.get("connector").keys()) {
                ModelNode connectorRef = connectorRefs.get(connectorName);
                connectorNames.add(connectorName);
            }
            config.setConnectorNames(connectorNames);
        }
        config.setConsumerMaxRate(CommonAttributes.CONSUMER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        config.setConsumerWindowSize(CommonAttributes.CONSUMER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        ModelNode discoveryGroupName = CommonAttributes.DISCOVERY_GROUP_NAME.resolveModelAttribute(context, model);
        if (discoveryGroupName.isDefined()) {
            config.setDiscoveryGroupName(discoveryGroupName.asString());
        }
        config.setDupsOKBatchSize(CommonAttributes.DUPS_OK_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        config.setFailoverOnInitialConnection(CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.resolveModelAttribute(context, model).asBoolean());
        ModelNode groupId = CommonAttributes.GROUP_ID.resolveModelAttribute(context, model);
        if (groupId.isDefined()) {
            config.setGroupID(groupId.asString());
        }
        if ((lbcn = CommonAttributes.LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, model)).isDefined()) {
            config.setLoadBalancingPolicyClassName(lbcn.asString());
        }
        config.setMaxRetryInterval(CommonAttributes.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        config.setMinLargeMessageSize(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt());
        config.setPreAcknowledge(CommonAttributes.PRE_ACK.resolveModelAttribute(context, model).asBoolean());
        config.setProducerMaxRate(CommonAttributes.PRODUCER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        config.setProducerWindowSize(CommonAttributes.PRODUCER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        config.setReconnectAttempts(CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        config.setRetryInterval(CommonAttributes.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        config.setRetryIntervalMultiplier(CommonAttributes.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble());
        config.setScheduledThreadPoolMaxSize(CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        config.setThreadPoolMaxSize(CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        config.setTransactionBatchSize(CommonAttributes.TRANSACTION_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        config.setUseGlobalPools(CommonAttributes.USE_GLOBAL_POOLS.resolveModelAttribute(context, model).asBoolean());
        config.setLoadBalancingPolicyClassName(CommonAttributes.LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, model).asString());
        JMSFactoryType jmsFactoryType = ConnectionFactoryAdd.getFactoryType(CommonAttributes.CONNECTION_FACTORY_TYPE.resolveModelAttribute(context, model).asString());
        config.setFactoryType(jmsFactoryType);
        return config;
    }

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (AttributeDefinition attribute : JMSServices.CONNECTION_FACTORY_ATTRS) {
            String attrName = attribute.getName();
            if (!subModel.hasDefined(attrName)) continue;
            operation.get(attrName).set(subModel.get(attrName));
        }
        return operation;
    }

    private static JMSFactoryType getFactoryType(String factoryType) {
        if (factoryType == null || factoryType.equals("GENERIC")) {
            return JMSFactoryType.CF;
        }
        if (factoryType.equals("QUEUE")) {
            return JMSFactoryType.QUEUE_CF;
        }
        if (factoryType.equals("TOPIC")) {
            return JMSFactoryType.TOPIC_CF;
        }
        if (factoryType.equals("XA_GENERIC")) {
            return JMSFactoryType.XA_CF;
        }
        if (factoryType.equals("XA_QUEUE")) {
            return JMSFactoryType.QUEUE_XA_CF;
        }
        if (factoryType.equals("XA_TOPIC")) {
            return JMSFactoryType.TOPIC_XA_CF;
        }
        return JMSFactoryType.CF;
    }
}

