/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSQueueService
implements Service<Void> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final String queueName;
    private final String selectorString;
    private final boolean durable;
    private final String[] jndi;

    public JMSQueueService(String queueName, String selectorString, boolean durable, String[] jndi) {
        this.queueName = queueName;
        this.selectorString = selectorString;
        this.durable = durable;
        this.jndi = jndi;
    }

    public synchronized void start(StartContext context) throws StartException {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.createQueue(false, this.queueName, this.selectorString, this.durable, this.jndi);
        }
        catch (Exception e) {
            throw new StartException(MessagingMessages.MESSAGES.failedToCreate("queue"), (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.removeQueueFromJNDI(this.queueName);
        }
        catch (Exception e) {
            MessagingLogger.MESSAGING_LOGGER.failedToDestroy(e, "queue", this.queueName);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }
}

