/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.jboss.as.messaging.HornetQDefaultCredentials;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.jms.AS7BindingRegistry;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.SecurityActions;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSService
implements Service<JMSServerManager> {
    private final InjectedValue<HornetQServer> hornetQServer = new InjectedValue();
    private JMSServerManager jmsServer;

    public static ServiceController<?> addService(ServiceTarget target, ServiceName hqServiceName, ServiceListener<Object> ... listeners) {
        JMSService service = new JMSService();
        return target.addService(JMSServices.getJmsManagerBaseServiceName(hqServiceName), (Service)service).addDependency(hqServiceName, HornetQServer.class, service.getHornetQServer()).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    protected JMSService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        try {
            JMSServerManagerImpl jmsServer = new JMSServerManagerImpl((HornetQServer)this.hornetQServer.getValue(), (BindingRegistry)new AS7BindingRegistry(context.getController().getServiceContainer()));
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                SecurityActions.setContextClassLoader(loader);
                jmsServer.start();
                if (!((HornetQServer)this.hornetQServer.getValue()).getConfiguration().isBackup()) {
                    ((HornetQServer)this.hornetQServer.getValue()).getRemotingService().allowInvmSecurityOverride(new HornetQPrincipal(HornetQDefaultCredentials.getUsername(), HornetQDefaultCredentials.getPassword()));
                }
            }
            finally {
                SecurityActions.setContextClassLoader(null);
            }
            this.jmsServer = jmsServer;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsServer = this.jmsServer;
        this.jmsServer = null;
        try {
            jmsServer.stop();
        }
        catch (Exception e) {
            MessagingLogger.MESSAGING_LOGGER.errorStoppingJmsServer(e);
        }
    }

    public synchronized JMSServerManager getValue() throws IllegalStateException {
        JMSServerManager jmsServer = this.jmsServer;
        if (jmsServer == null) {
            throw new IllegalStateException();
        }
        return jmsServer;
    }

    InjectedValue<HornetQServer> getHornetQServer() {
        return this.hornetQServer;
    }
}

