/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.cache;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.UnsupportedCriterium;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleRoleType;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.cache.AbstractSearch;
import org.picketlink.idm.impl.cache.GroupSearchImpl;
import org.picketlink.idm.impl.cache.RelationshipSearchImpl;
import org.picketlink.idm.impl.cache.RoleSearchImpl;
import org.picketlink.idm.impl.cache.RoleTypeSearchImpl;
import org.picketlink.idm.impl.cache.UserSearchImpl;

public class SearchEqualityTestCase
extends TestCase {
    public void testRoleTypeSearchEquality() throws UnsupportedCriterium {
        SimpleUser user1 = new SimpleUser("john");
        SimpleGroup group1 = new SimpleGroup("platform", "simpleType");
        IdentitySearchCriteria criteria = new IdentitySearchCriteriaImpl().page(0, 2).sort(SortOrder.ASCENDING);
        RoleTypeSearchImpl rts1 = new RoleTypeSearchImpl();
        rts1.setUser((User)user1);
        rts1.setGroup((Group)group1);
        rts1.setSearchCriteria(criteria);
        RoleTypeSearchImpl rts2 = new RoleTypeSearchImpl();
        rts2.setUser((User)user1);
        rts2.setGroup((Group)group1);
        RoleTypeSearchImpl rts3 = new RoleTypeSearchImpl();
        rts3.setUser((User)user1);
        rts3.setGroup((Group)group1);
        SearchEqualityTestCase.assertFalse((boolean)rts1.equals((Object)rts2));
        SearchEqualityTestCase.assertFalse((rts1.hashCode() == rts2.hashCode() ? 1 : 0) != 0);
        SearchEqualityTestCase.assertTrue((boolean)rts3.equals((Object)rts2));
        SearchEqualityTestCase.assertTrue((rts3.hashCode() == rts2.hashCode() ? 1 : 0) != 0);
    }

    public void testUserSearchEquality() throws UnsupportedCriterium {
        IdentitySearchCriteria criteria = new IdentitySearchCriteriaImpl().page(0, 2).sort(SortOrder.ASCENDING);
        UserSearchImpl us1 = new UserSearchImpl();
        us1.setUserId("someone");
        us1.addRelatedGroupId("somegroup");
        us1.setSearchCriteria(criteria);
        UserSearchImpl us2 = new UserSearchImpl();
        us2.setUserId("someone");
        us2.addRelatedGroupId("somegroup");
        UserSearchImpl us3 = new UserSearchImpl();
        us3.setUserId("someone");
        us3.addRelatedGroupId("somegroup");
        UserSearchImpl us4 = new UserSearchImpl();
        us4.setUserId("someone");
        us4.addRelatedGroupId("somegroup");
        us4.setCascade(Boolean.valueOf(false));
        SearchEqualityTestCase.assertFalse((boolean)us1.equals((Object)us2));
        SearchEqualityTestCase.assertFalse((us1.hashCode() == us2.hashCode() ? 1 : 0) != 0);
        SearchEqualityTestCase.assertTrue((boolean)us3.equals((Object)us2));
        SearchEqualityTestCase.assertTrue((us3.hashCode() == us2.hashCode() ? 1 : 0) != 0);
        SearchEqualityTestCase.assertFalse((boolean)us2.equals((Object)us4));
        SearchEqualityTestCase.assertFalse((us2.hashCode() == us4.hashCode() ? 1 : 0) != 0);
    }

    public void testGroupSearchEquality() throws UnsupportedCriterium {
        IdentitySearchCriteria criteria = new IdentitySearchCriteriaImpl().page(0, 2);
        GroupSearchImpl gs1 = new GroupSearchImpl();
        gs1.addRelatedGroupId("somegroup");
        gs1.setSearchCriteria(criteria);
        GroupSearchImpl gs2 = new GroupSearchImpl();
        gs2.addRelatedGroupId("somegroup");
        GroupSearchImpl gs3 = new GroupSearchImpl();
        gs3.addRelatedGroupId("somegroup");
        gs3.setSearchCriteria(new IdentitySearchCriteriaImpl().page(0, 2));
        SearchEqualityTestCase.assertFalse((boolean)gs1.equals((Object)gs2));
        SearchEqualityTestCase.assertFalse((gs1.hashCode() == gs2.hashCode() ? 1 : 0) != 0);
        SearchEqualityTestCase.assertTrue((boolean)gs3.equals((Object)gs1));
        SearchEqualityTestCase.assertTrue((gs3.hashCode() == gs1.hashCode() ? 1 : 0) != 0);
    }

    public void testRoleSearchEquality() throws UnsupportedCriterium {
        IdentitySearchCriteria criteria = new IdentitySearchCriteriaImpl().page(0, 2);
        SimpleRoleType rt = new SimpleRoleType("simple");
        RoleSearchImpl rs1 = new RoleSearchImpl();
        rs1.setRoleType((RoleType)rt);
        rs1.setSearchCriteria(criteria);
        RoleSearchImpl rs2 = new RoleSearchImpl();
        rs2.setRoleType((RoleType)rt);
        RoleSearchImpl rs3 = new RoleSearchImpl();
        rs3.setRoleType((RoleType)rt);
        rs3.setSearchCriteria(criteria);
        SearchEqualityTestCase.assertFalse((boolean)rs1.equals((Object)rs2));
        SearchEqualityTestCase.assertFalse((rs1.hashCode() == rs2.hashCode() ? 1 : 0) != 0);
        SearchEqualityTestCase.assertTrue((boolean)rs3.equals((Object)rs1));
        SearchEqualityTestCase.assertTrue((rs3.hashCode() == rs1.hashCode() ? 1 : 0) != 0);
    }

    public void testRelationshipSearchEquality() throws UnsupportedCriterium {
        IdentitySearchCriteria criteria = new IdentitySearchCriteriaImpl().page(0, 2);
        RelationshipSearchImpl rs1 = new RelationshipSearchImpl();
        rs1.setMembers(new ArrayList());
        rs1.setSearchCriteria(criteria);
        RelationshipSearchImpl rs2 = new RelationshipSearchImpl();
        rs2.setMembers(new ArrayList());
        RelationshipSearchImpl rs3 = new RelationshipSearchImpl();
        rs3.setMembers(new ArrayList());
        rs3.setSearchCriteria(new IdentitySearchCriteriaImpl().page(0, 3));
        SearchEqualityTestCase.assertFalse((boolean)rs1.equals((Object)rs2));
        SearchEqualityTestCase.assertFalse((rs1.hashCode() == rs2.hashCode() ? 1 : 0) != 0);
        SearchEqualityTestCase.assertFalse((boolean)rs3.equals((Object)rs1));
        SearchEqualityTestCase.assertFalse((rs3.hashCode() == rs1.hashCode() ? 1 : 0) != 0);
        AbstractSearch rs4 = new AbstractSearch(){};
        rs4.setSearchCriteria(criteria);
        RelationshipSearchImpl rs5 = new RelationshipSearchImpl();
        rs5.setSearchCriteria(criteria);
        SearchEqualityTestCase.assertFalse((boolean)rs4.equals((Object)rs5));
        SearchEqualityTestCase.assertFalse((rs4.hashCode() == rs5.hashCode() ? 1 : 0) != 0);
    }
}

