/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.configuration;

import java.io.File;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;

public class ConfigurationTestCase
extends TestCase {
    public void testSimple() throws Exception {
        IdentityConfigurationMetaData config = JAXB2IdentityConfiguration.createConfigurationMetaData((File)new File("src/test/resources/store-test-config.xml"));
        ConfigurationTestCase.assertNotNull((Object)config);
        ConfigurationTestCase.assertEquals((String)"HibernateTestStore", (String)((IdentityStoreConfigurationMetaData)config.getIdentityStores().get(0)).getId());
    }

    public void testSystemPropertiesSubstitution() throws Exception {
        System.setProperty("identity.store.id", "HibernateStore");
        System.setProperty("relationship.type1", "JBOSS_IDENTITY_MEMBERSHIP");
        System.setProperty("relationship.type2", "JBOSS_IDENTITY_ROLLE");
        System.setProperty("option2.value", "Value of option2");
        System.setProperty("option3.value", "Value of option3");
        System.setProperty("option5.value1", "Option5 value1");
        System.setProperty("option5.value2", "Option5 value2");
        System.setProperty("option6.value1", "Option6 value1");
        System.setProperty("option7.value2", "Option7 value2");
        System.setProperty("option8.value2", "Option8 value2");
        System.setProperty("option8.value4", "Option8 value4");
        IdentityConfigurationMetaData config = JAXB2IdentityConfiguration.createConfigurationMetaData((File)new File("src/test/resources/example-system-properties-config.xml"));
        ConfigurationTestCase.assertNotNull((Object)config);
        ConfigurationTestCase.assertEquals((String)"HibernateStore", (String)((IdentityRepositoryConfigurationMetaData)config.getRepositories().get(0)).getDefaultIdentityStoreId());
        ConfigurationTestCase.assertEquals((String)"HibernateStore", (String)((IdentityRepositoryConfigurationMetaData)config.getRepositories().get(0)).getDefaultAttributeStoreId());
        ConfigurationTestCase.assertEquals((String)"true", (String)((String)((IdentityRepositoryConfigurationMetaData)config.getRepositories().get(0)).getOption("allowNotDefinedAttributes").get(0)));
        ConfigurationTestCase.assertEquals((String)"HibernateStore", (String)((IdentityStoreConfigurationMetaData)config.getIdentityStores().get(0)).getId());
        ConfigurationTestCase.assertTrue((boolean)((IdentityStoreConfigurationMetaData)config.getIdentityStores().get(0)).getSupportedRelationshipTypes().contains("JBOSS_IDENTITY_MEMBERSHIP"));
        ConfigurationTestCase.assertTrue((boolean)((IdentityStoreConfigurationMetaData)config.getIdentityStores().get(0)).getSupportedRelationshipTypes().contains("JBOSS_IDENTITY_ROLLE"));
        Map options = ((IdentityStoreConfigurationMetaData)config.getIdentityStores().get(0)).getOptions();
        ConfigurationTestCase.assertEquals((String)"option1Value", (String)((String)((List)options.get("option1")).get(0)));
        ConfigurationTestCase.assertEquals((String)"Value of option2", (String)((String)((List)options.get("option2")).get(0)));
        ConfigurationTestCase.assertEquals((String)"Value of option3", (String)((String)((List)options.get("option3")).get(0)));
        ConfigurationTestCase.assertEquals((String)"defaultValue", (String)((String)((List)options.get("option4")).get(0)));
        ConfigurationTestCase.assertEquals((String)"Option5 value1", (String)((String)((List)options.get("option5")).get(0)));
        ConfigurationTestCase.assertEquals((String)"Option6 value1", (String)((String)((List)options.get("option6")).get(0)));
        ConfigurationTestCase.assertEquals((String)"Option7 value2", (String)((String)((List)options.get("option7")).get(0)));
        ConfigurationTestCase.assertEquals((String)"something1 Option8 value2 something2 defaultValue something3 Option8 value4 something4", (String)((String)((List)options.get("option8")).get(0)));
        ConfigurationTestCase.assertEquals((String)"something1 ${} something2", (String)((String)((List)options.get("option9")).get(0)));
        ConfigurationTestCase.assertEquals((String)"${option10.value1}", (String)((String)((List)options.get("option10")).get(0)));
        ConfigurationTestCase.assertEquals((String)"value2", (String)((String)((List)options.get("option10")).get(1)));
        ConfigurationTestCase.assertEquals((String)"defaultValue3", (String)((String)((List)options.get("option10")).get(2)));
    }
}

