/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.credential;

import java.io.FileNotFoundException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.picketlink.idm.impl.credential.FileReadingSaltEncoder;
import org.picketlink.idm.impl.credential.HashingEncoder;

public class CredentialEncoderTestCase
extends TestCase {
    public void testHashingOnlyEncoder() {
        HashingEncoder encoder = new HashingEncoder();
        String userName = "theduke";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("credentialEncoder.hashAlgorithm", "MD5");
        encoder.initialize(parameters);
        Assert.assertEquals((String)"b9cd9b73428cda4a83651ad1658b439c", (String)encoder.encodeCredential(userName, "gtn"));
        Assert.assertEquals((String)"5f4dcc3b5aa765d61d8327deb882cf99", (String)encoder.encodeCredential(userName, "password"));
        Assert.assertEquals((String)"7c6a180b36896a0a8c02787eeafb0e4c", (String)encoder.encodeCredential(userName, "password1"));
        Assert.assertEquals((String)"95a5b49a1f092b442ff63a837b548431", (String)encoder.encodeCredential(userName, "theduke"));
        Assert.assertEquals((String)"b9cd9b73428cda4a83651ad1658b439c", (String)encoder.encodeCredential("someOtherDuke", "gtn"));
        parameters.clear();
        parameters.put("credentialEncoder.hashAlgorithm", "SHA1");
        encoder.initialize(parameters);
        Assert.assertEquals((String)"04c501fa7469d1aaad50ba59fa9672629601c125", (String)encoder.encodeCredential(userName, "gtn"));
        parameters.clear();
        parameters.put("credentialEncoder.hashAlgorithm", "SHA-256");
        encoder.initialize(parameters);
        Assert.assertEquals((String)"30fba9ec34d4372a85d4fa253d4d7c02f8d96de5e90a01b8f6686f6a448207da", (String)encoder.encodeCredential(userName, "gtn"));
        parameters.clear();
        encoder.initialize(parameters);
        Assert.assertEquals((String)"b9cd9b73428cda4a83651ad1658b439c", (String)encoder.encodeCredential(userName, "gtn"));
        parameters.put("credentialEncoder.hashAlgorithm", "SHA-64879");
        encoder.initialize(parameters);
        try {
            encoder.encodeCredential(userName, "gtn");
            CredentialEncoderTestCase.fail((String)"Exception should be thrown but it's not");
        }
        catch (RuntimeException re) {
            Assert.assertNotNull((Object)re.getCause());
            Assert.assertEquals(re.getCause().getClass(), NoSuchAlgorithmException.class);
        }
        catch (Exception e) {
            CredentialEncoderTestCase.fail((String)("Not-expected exception " + e));
        }
    }

    public void testFileReadingSaltEncoder() {
        FileReadingSaltEncoder encoder = new FileReadingSaltEncoder();
        String userName = "theduke";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("credentialEncoder.hashAlgorithm", "SHA-256");
        parameters.put("credentialEncoder.fileLocation", "salt/salt1.txt");
        encoder.initialize(parameters);
        Assert.assertEquals((String)"57eb0c5a143899270f49bf82fd6db49809b765c138b6752a3bfc4862cdc4d73d", (String)encoder.encodeCredential(userName, "gtn"));
        Assert.assertEquals((String)"7642c2b34bcafafedecaaa9bce1812a6b76f902ebf0265313e7623edde80905f", (String)encoder.encodeCredential(userName, "password"));
        Assert.assertEquals((String)"d01c61872852742d4a83b75cf243e8a50220e006567babc60a075757decfcb00", (String)encoder.encodeCredential("someOtherDuke", "gtn"));
        Assert.assertEquals((String)"57eb0c5a143899270f49bf82fd6db49809b765c138b6752a3bfc4862cdc4d73d", (String)encoder.encodeCredential(userName, "gtn"));
        parameters.clear();
        parameters.put("credentialEncoder.hashAlgorithm", "SHA-256");
        parameters.put("credentialEncoder.fileLocation", "salt/salt2.txt");
        encoder.initialize(parameters);
        Assert.assertEquals((String)"01ada1f0772bd7665875160e62ebf9679c9404e225b709eaede532b3210f9c48", (String)encoder.encodeCredential(userName, "gtn"));
        Assert.assertEquals((String)"523d43e1f4e697766ca5d230eb2a7d7bcd2fb2399c0d49965a532885dfc10ca1", (String)encoder.encodeCredential(userName, "password"));
        try {
            parameters.clear();
            parameters.put("credentialEncoder.hashAlgorithm", "SHA-256");
            encoder.initialize(parameters);
            Assert.fail((String)"Test should fail during initialization because non-existing location");
        }
        catch (IllegalStateException re) {
        }
        catch (Exception e) {
            Assert.fail((String)("Not-expected exception " + e));
        }
        try {
            parameters.clear();
            parameters.put("credentialEncoder.hashAlgorithm", "SHA-256");
            parameters.put("credentialEncoder.fileLocation", "/opt/nonexistingg/salt2.txt");
            encoder.initialize(parameters);
            Assert.fail((String)"Test should fail during initialization because non-existing location");
        }
        catch (RuntimeException re) {
            Assert.assertNotNull((Object)re.getCause());
            Assert.assertEquals(FileNotFoundException.class, re.getCause().getClass());
        }
        catch (Exception e) {
            Assert.fail((String)("Not-expected exception " + e));
        }
    }
}

