/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.helper;

import junit.framework.TestCase;
import org.picketlink.idm.impl.helper.Tools;

public class ToolsTestCase
extends TestCase {
    public void testDnComparison() {
        String root = "uid=root, ou=Organization, o=gatein,dc=example,dc=com ";
        String john = "uid=john, ou=My Big Organization Unit,o=gatein org,dc= example ,dc=com ";
        String mary = "uid=mary,ou=OrganizationUnit,o=gatein,dc=example,dc=com";
        String organization1 = " ou=Organization,o=gatein,  dc=example ,dc=com";
        String organization2 = "ou=My Big Organization Unit,o=gatein org,dc= example ,dc=com";
        String organization3 = "uid=mary,ou=OrganizationUnit,o=gatein,dc=example,dc=com";
        String escapeCharsDn = "cn= some\\,\\,thin\\=g , ou= pl\\ at\\.form ,o=gr\\=oup\\=,o=gatein ";
        ToolsTestCase.assertEquals((String)"uid=root,ou=organization,o=gatein,dc=example,dc=com", (String)Tools.dnFormatWhitespaces((String)root));
        ToolsTestCase.assertEquals((String)"uid=john,ou=my big organization unit,o=gatein org,dc=example,dc=com", (String)Tools.dnFormatWhitespaces((String)john));
        ToolsTestCase.assertEquals((String)"uid=mary,ou=organizationunit,o=gatein,dc=example,dc=com", (String)Tools.dnFormatWhitespaces((String)mary));
        ToolsTestCase.assertTrue((boolean)Tools.dnEndsWith((String)root, (String)organization1));
        ToolsTestCase.assertTrue((boolean)Tools.dnEndsWith((String)john, (String)organization2));
        ToolsTestCase.assertTrue((boolean)Tools.dnEndsWith((String)mary, (String)organization3));
        ToolsTestCase.assertFalse((boolean)Tools.dnEndsWith((String)root, (String)organization3));
        ToolsTestCase.assertEquals((String)"cn=some\\,\\,thin\\=g,ou=pl\\ at\\.form,o=gr\\=oup\\=,o=gatein", (String)Tools.dnFormatWhitespaces((String)escapeCharsDn));
    }

    public void testConvertToInt() {
        Integer i1 = 1456;
        Long l1 = 14567897L;
        ToolsTestCase.assertTrue((Tools.convertToInt((Number)i1) == 1456 ? 1 : 0) != 0);
        ToolsTestCase.assertTrue((Tools.convertToInt((Number)l1) == 14567897 ? 1 : 0) != 0);
    }
}

