/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.cache;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.ws.security.cache.ReplayCache;

public class MemoryReplayCache
implements ReplayCache {
    public static final long DEFAULT_TTL = 300L;
    public static final long MAX_TTL = 3600L;
    private Set<ReplayCacheIdentifier> cache = Collections.synchronizedSet(new HashSet());

    @Override
    public void add(String identifier) {
        this.add(identifier, 300L);
    }

    @Override
    public void add(String identifier, long timeToLive) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        ReplayCacheIdentifier cacheIdentifier = new ReplayCacheIdentifier();
        cacheIdentifier.setIdentifier(identifier);
        long ttl = timeToLive;
        if (ttl < 0L || ttl > 3600L) {
            ttl = 300L;
        }
        Date expires = new Date();
        long currentTime = expires.getTime();
        expires.setTime(currentTime + ttl * 1000L);
        cacheIdentifier.setExpiry(expires);
        this.cache.add(cacheIdentifier);
    }

    @Override
    public boolean contains(String identifier) {
        this.processTokenExpiry();
        if (identifier != null && !"".equals(identifier)) {
            ReplayCacheIdentifier cacheIdentifier = new ReplayCacheIdentifier();
            cacheIdentifier.setIdentifier(identifier);
            return this.cache.contains(cacheIdentifier);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTokenExpiry() {
        Date current = new Date();
        Set<ReplayCacheIdentifier> set = this.cache;
        synchronized (set) {
            Iterator<ReplayCacheIdentifier> iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getExpiry().before(current)) continue;
                iterator.remove();
            }
        }
    }

    private static class ReplayCacheIdentifier {
        private String identifier;
        private Date expires;

        private ReplayCacheIdentifier() {
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setExpiry(Date expires) {
            this.expires = expires;
        }

        public Date getExpiry() {
            return this.expires;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReplayCacheIdentifier)) {
                return false;
            }
            ReplayCacheIdentifier replayCacheIdentifier = (ReplayCacheIdentifier)o;
            if (this.identifier == null && replayCacheIdentifier.identifier != null) {
                return false;
            }
            return this.identifier == null || this.identifier.equals(replayCacheIdentifier.identifier);
        }

        public int hashCode() {
            return this.identifier != null ? this.identifier.hashCode() : 0;
        }
    }
}

